/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpClientUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtils.class);
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtils.class);
    public static final Charset CHARSET = StandardCharsets.UTF_8;

    private HttpClientUtils() {
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(35000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static CloseableHttpClient getHttpClient(int timeOut) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeOut).setSocketTimeout(timeOut).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String doGet(String url, Map<String, String> params) {
        log.info("doGet.url:{}, params:{}", (Object)url, params);
        return HttpClientUtils.doGet(url, params, CHARSET);
    }

    public static String doPost(String url, Map<String, String> params) {
        log.info("doPost.url:{}, params:{}", (Object)url, params);
        return HttpClientUtils.doPost(url, params, CHARSET);
    }

    public static String doGet(String url, Map<String, String> params, Charset charset) {
        return HttpClientUtils.doGet(url, params, charset, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> params, Charset charset, Collection<Header> headers) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            if (params != null && !params.isEmpty()) {
                ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry entry : params.entrySet()) {
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair((String)entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpGet.addHeader(header);
                }
            }
            String string = HttpClientUtils.execute(httpClient, (HttpUriRequest)httpGet, charset);
            return string;
        }
        catch (Exception e) {
            log.error("doGet exception - ", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> params, Map<String, String> headers, Charset charset) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            if (params != null && !params.isEmpty()) {
                ArrayList pairs = Lists.newArrayList();
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
                url = url + "?" + EntityUtils.toString((HttpEntity)new UrlEncodedFormEntity((Iterable)pairs, charset));
            }
            HttpGet httpGet = new HttpGet(url);
            HttpClientUtils.setHeaders((HttpRequestBase)httpGet, headers);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpGet.abort();
                throw new IllegalStateException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (String)"utf-8");
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            String string = result;
            return string;
        }
        catch (IOException e) {
            log.error("doGet exception - ", (Throwable)e);
            throw e;
        }
    }

    public static String doPost(String url, Map<String, String> params, Charset charset) {
        return HttpClientUtils.doPost(url, params, charset, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, String> params, Charset charset, Collection<Header> headers) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            ArrayList<BasicNameValuePair> pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && !pairs.isEmpty()) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, charset));
            }
            if (CollectionUtils.isNotEmpty(headers)) {
                for (Header header : headers) {
                    httpPost.addHeader(header);
                }
            }
            String string = HttpClientUtils.execute(httpClient, (HttpUriRequest)httpPost, charset);
            return string;
        }
        catch (Exception e) {
            log.error("doPost exception - ", (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, String> params, Map<String, String> headers, Charset charset) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            ArrayList pairs = null;
            if (params != null && !params.isEmpty()) {
                pairs = Lists.newArrayListWithCapacity((int)params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    pairs.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            HttpPost httpPost = new HttpPost(url);
            if (pairs != null && !pairs.isEmpty()) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity((Iterable)pairs, charset));
            }
            HttpClientUtils.setHeaders((HttpRequestBase)httpPost, headers);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new IllegalStateException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            String result = null;
            if (entity != null) {
                result = EntityUtils.toString((HttpEntity)entity, (Charset)charset);
            }
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            String string = result;
            return string;
        }
        catch (IOException e) {
            log.error("doPost exception - ", (Throwable)e);
            throw e;
        }
    }

    private static void setHeaders(HttpRequestBase req, Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)req).setHeader(arg_0, arg_1));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostFiles(String url, Map<String, String> params, Map<String, File> files) {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(60000).build();
        try (CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(config).build();){
            logger.info("doPost - start, url:{}", (Object)url);
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: get httpClinet, cost:{}", (Object)(end - start));
            HttpPost httpPost = new HttpPost(url);
            MultipartEntity multipartEntity = new MultipartEntity();
            long getPostTime = System.currentTimeMillis();
            logger.info("HttpClientUtils.doPost: getHttppOST cost:{}", (Object)(getPostTime - end));
            for (Map.Entry<String, File> entry : files.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new FileBody(entry.getValue()));
            }
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                multipartEntity.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
            }
            httpPost.setEntity((HttpEntity)multipartEntity);
            logger.info("doPost - execute, url:{}", (Object)url);
            String string = HttpClientUtils.execute(httpClient, (HttpUriRequest)httpPost, null);
            return string;
        }
        catch (Exception e) {
            logger.error("doPost exception - ", (Throwable)e);
            return null;
        }
    }

    public static String doJsonPost(String url, Map<String, Object> params, Charset charset) throws IOException {
        return HttpClientUtils.doJsonPost(url, params, charset, null);
    }

    public static String doJsonPost(String url, Map<String, Object> params, Charset charset, Integer timeOut) throws IOException {
        String jsonPost = JacksonUtil.obj2Str(params);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpClient httpClient = timeOut == null ? HttpClientUtils.getHttpClient() : HttpClientUtils.getHttpClient(timeOut);){
            String string = HttpClientUtils.execute(httpClient, (HttpUriRequest)httpPost, charset);
            return string;
        }
    }

    public static String doJsonPost(String url, String jsonPost) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            String string = HttpClientUtils.execute(httpClient, (HttpUriRequest)httpPost, null);
            return string;
        }
    }

    private static String execute(CloseableHttpClient httpClient, @NonNull HttpUriRequest request, Charset charset) throws IOException {
        if (request == null) {
            throw new NullPointerException("request is marked non-null but is null");
        }
        if (charset == null) {
            charset = CHARSET;
        }
        try {
            long current = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("send request:{}", (Object)request);
            }
            String result = (String)httpClient.execute(request, (ResponseHandler)new StringResponseHandler(request, charset));
            logger.info("cost:{} ms to execute http method:{},url:{}", new Object[]{System.currentTimeMillis() - current, request.getMethod(), request.getURI()});
            return result;
        }
        catch (IOException e) {
            log.error("execute http request error, url:{}", (Object)request.getURI(), (Object)e);
            throw e;
        }
    }

    public static byte[] download(String url) throws IOException {
        HttpGet httpGet = new HttpGet(url);
        CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            httpGet.abort();
            throw new IllegalStateException("download - error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        byte[] result = IOUtils.toByteArray((InputStream)entity.getContent());
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static byte[] downloadByPost(String url, Map<String, String> params) throws IOException {
        String jsonPost = JacksonUtil.obj2Str(params);
        HttpPost httpPost = new HttpPost(url);
        StringEntity requestEntity = new StringEntity(jsonPost, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)requestEntity);
        try (CloseableHttpClient httpClient = HttpClientUtils.getHttpClient();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                httpPost.abort();
                throw new IllegalStateException("download - error status code :" + statusCode);
            }
            HttpEntity entity = response.getEntity();
            byte[] result = IOUtils.toByteArray((InputStream)entity.getContent());
            EntityUtils.consume((HttpEntity)entity);
            response.close();
            byte[] byArray = result;
            return byArray;
        }
    }

    static class StringResponseHandler
    implements ResponseHandler<String> {
        private HttpUriRequest request;
        private Charset charset;

        public StringResponseHandler(HttpUriRequest request, Charset charset) {
            this.request = request;
            this.charset = charset;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String handleResponse(HttpResponse response) throws IOException {
            try {
                StatusLine status = response.getStatusLine();
                if (logger.isDebugEnabled()) {
                    logger.debug("doPost - execute end, url:{}, status:{}", (Object)this.request.getURI(), (Object)status);
                }
                if (status.getStatusCode() != 200) {
                    this.request.abort();
                    throw new IllegalStateException("HttpClient,error status code :" + status);
                }
                HttpEntity responseEntity = response.getEntity();
                String result = null;
                if (responseEntity != null) {
                    result = EntityUtils.toString((HttpEntity)responseEntity, (Charset)this.charset);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("http response - url:{}, status:{}, response:{}", new Object[]{this.request.getURI(), status, result});
                }
                String string = result;
                return string;
            }
            finally {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    try {
                        EntityUtils.consume((HttpEntity)entity);
                    }
                    catch (IOException e) {
                        log.error("close http response error", (Throwable)e);
                    }
                }
            }
        }
    }
}

