/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlToJson {
    private static final Logger log = LoggerFactory.getLogger(HtmlToJson.class);
    private static final Set<String> NODE_FILTER_SET = Sets.newHashSet((Object[])new String[]{"p", "a", "abbr", "b", "blockquote", "br", "code", "col", "colgroup", "dd", "del", "div", "dl", "dt", "em", "fieldset", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "img", "ins", "label", "legend", "li", "ol", "q", "span", "strong", "sub", "sup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "ul", "#text"});
    private static final Set<String> ATTR_FILTER_SET = Sets.newHashSet((Object[])new String[]{"span", "width", "alt", "src", "height", "start", "type", "colspan", "rowspan", "style", "class"});

    private HtmlToJson() {
    }

    public static String parse(String html) {
        if (StringUtils.isBlank((CharSequence)html)) {
            return "";
        }
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>();
        html = HtmlToJson.htmlParse(html);
        Document document = Jsoup.parse((String)html);
        List nodeList = ((Element)document.getElementsByTag("body").get(0)).childNodes();
        return JSONObject.toJSONString(HtmlToJson.html2json(nodes, nodeList));
    }

    private static List<Map<String, Object>> html2json(List<Map<String, Object>> nodes, List<Node> nodeList) {
        for (Node node : nodeList) {
            String nodeName = HtmlToJson.replaceNodeName(node.nodeName());
            if (!HtmlToJson.nodeFilter(nodeName).booleanValue()) continue;
            HashMap<String, Object> map = new HashMap<String, Object>(4);
            if ("#text".equals(nodeName)) {
                map.put("type", "text");
                map.put("text", "".equals(node.toString()) ? " " : node.toString().replace("(|M-Y|)", "&#"));
            } else {
                map.put("name", nodeName);
            }
            Attributes attributes = node.attributes();
            HashMap<String, String> attrs = new HashMap<String, String>(attributes.size());
            for (Attribute attribute : attributes) {
                if (!HtmlToJson.attrFilter(attribute.getKey()).booleanValue()) continue;
                attrs.put(attribute.getKey(), attribute.getValue());
            }
            if ("img".equals(nodeName)) {
                attrs.merge("style", "max-width: 100%;vertical-align:top;", (a, b) -> a + b);
            }
            if (!attrs.isEmpty()) {
                map.put("attrs", attrs);
            }
            ArrayList<Map<String, Object>> childrens = new ArrayList<Map<String, Object>>();
            HtmlToJson.html2json(childrens, node.childNodes());
            if (!childrens.isEmpty()) {
                map.put("children", childrens);
            }
            nodes.add(map);
        }
        return nodes;
    }

    private static String replaceNodeName(String nodeName) {
        return nodeName.replace("section", "div");
    }

    private static Boolean nodeFilter(String nodeName) {
        return NODE_FILTER_SET.contains(nodeName);
    }

    private static Boolean attrFilter(String attrName) {
        return ATTR_FILTER_SET.contains(attrName);
    }

    private static String htmlParse(String html) {
        return html.replace("&nbsp", "(|M-Y|)160").replace("&lt", "(|M-Y|)60").replace("&gt", "(|M-Y|)62").replace("&amp", "(|M-Y|)38").replace("&quot", "(|M-Y|)34").replace("&apos", "(|M-Y|)39").replace("&cent", "(|M-Y|)162").replace("&pound", "(|M-Y|)163").replace("&yen", "(|M-Y|)165").replace("&euro", "(|M-Y|)8364").replace("&sect", "(|M-Y|)167").replace("&copy", "(|M-Y|)169").replace("&reg", "(|M-Y|)174").replace("&trade", "(|M-Y|)8482").replace("&times", "(|M-Y|)215").replace("&divide", "(|M-Y|)247");
    }
}

