/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.ConfigurableApplicationContext;

public final class GitInfoUtils {
    private static final Logger log = LoggerFactory.getLogger(GitInfoUtils.class);

    private GitInfoUtils() {
    }

    public static void print(ConfigurableApplicationContext context) {
        try {
            if (log.isInfoEnabled()) {
                GitProperties gitProperties = (GitProperties)context.getBean(GitProperties.class);
                log.info("Git branch: {}", (Object)gitProperties.get("branch"));
                log.info("Git build time: {}", (Object)gitProperties.get("build.time"));
                log.info("Git commit id: {}", (Object)gitProperties.get("commit.id.full"));
                log.info("Git commit user: {}<{}>", (Object)gitProperties.get("commit.user.name"), (Object)gitProperties.get("commit.user.email"));
                log.info("Git commit time: {}", (Object)gitProperties.get("commit.time"));
                log.info("Git commit message: {}", (Object)gitProperties.get("commit.message.full"));
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }
}

