/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.text.DecimalFormat;

public final class FormatUtils {
    private static final DecimalFormat decimalFormat = new DecimalFormat("0.00");
    public static final String DEFAULT_RATE = "0.00%";

    private FormatUtils() {
    }

    public static String getRate(Integer totalCount, Integer numCount) {
        if (totalCount != null && numCount != null && totalCount > 0) {
            if (numCount <= totalCount) {
                return decimalFormat.format((double)numCount.intValue() / (double)totalCount.intValue() * 100.0) + "%";
            }
            return "100.00%";
        }
        return DEFAULT_RATE;
    }

    public static String getRate(Long totalCount, Long numCount) {
        if (totalCount == null || totalCount == 0L) {
            return null;
        }
        if (numCount != null && totalCount > 0L) {
            if (numCount < totalCount) {
                return decimalFormat.format((double)numCount.longValue() / (double)totalCount.longValue() * 100.0) + "%";
            }
            return "100.00%";
        }
        return DEFAULT_RATE;
    }

    public static String getYuan(Long amount) {
        return String.format("%.2f", (double)amount.longValue() * 1.0 / 10000.0);
    }

    public static String getHourMinuteSecondString(long second) {
        long hours = second / 3600L;
        long minutes = second % 3600L / 60L;
        long remainingSeconds = second % 60L;
        return String.format("%d:%02d:%02d", hours, minutes, remainingSeconds);
    }

    public static String truncateString(String input, int maxLength) {
        if (input == null) {
            return "";
        }
        if (input.length() <= maxLength) {
            return input;
        }
        return input.substring(0, maxLength - 3) + "...";
    }

    public static String normalizeString(String input) {
        return input.replaceAll("\\s+", "");
    }
}

