/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class DownloadUtils {
    private DownloadUtils() {
    }

    public static File loadFile(String urlStr, String format) throws IOException {
        URL url = new URL(urlStr);
        URLConnection connection = url.openConnection();
        Path dir = Paths.get("./tmp", UUID.randomUUID().toString());
        Files.createDirectories(dir, new FileAttribute[0]);
        String originalName = UUID.randomUUID().toString();
        if (StringUtils.isBlank((CharSequence)format)) {
            format = DownloadUtils.getSuffix(urlStr);
        }
        String filename = StringUtils.isNotBlank((CharSequence)format) ? originalName + "." + format.trim() : originalName;
        Path filePath = dir.resolve(filename);
        try (InputStream in = connection.getInputStream();
             OutputStream output = Files.newOutputStream(filePath, new OpenOption[0]);){
            IOUtils.copy((InputStream)in, (OutputStream)output);
        }
        return filePath.toFile();
    }

    public static String getSuffix(String fileName) {
        int index;
        if (StringUtils.isNotBlank((CharSequence)fileName) && (index = fileName.lastIndexOf(46)) > 0) {
            return fileName.substring(index + 1);
        }
        return null;
    }
}

