/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtil {
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String YYYYMMDDHHMMSSSSS = "yyyyMMddHHmmssSSS";
    public static final String YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String HH_MM = "HH:mm";
    public static final String YYYYMMDDTHHMMSSX = "yyyy-MM-dd'T'HH:mm:ssX";
    private static Map<String, FastDateFormat> dateFormatMap = new ConcurrentHashMap<String, FastDateFormat>();
    private static long ONE_MINUTE_MILLIS = 60000L;
    private static Map<Integer, String> chineseWeekDayMap = Maps.newHashMap();

    public static String dateToDateString(Date date, String formatStr) {
        if (formatStr == null) {
            formatStr = YYYY_MM_DD_HH_MM_SS;
        }
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        return df.format(date);
    }

    public static String getCurTimeString(long time, String format) {
        if (StringUtils.isEmpty((CharSequence)format)) {
            format = YYYY_MM_DD_HH_MM_SS;
        }
        Date date = new Date(time * 1000L);
        return DateUtil.dateToDateString(date, format);
    }

    public static String getCurTimeString() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_HH_MM_SS);
    }

    public static String getCurTimeString(String formate) {
        return DateUtil.dateToDateString(new Date(), formate);
    }

    public static String getCurTimeString(long time) {
        Date date = new Date(time * 1000L);
        return DateUtil.dateToDateString(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static Integer getCurTimeInt() {
        return (int)(System.currentTimeMillis() / 1000L);
    }

    public static FastDateFormat getDateFormat(String formatStr) {
        FastDateFormat df = dateFormatMap.get(formatStr);
        if (df == null) {
            df = FastDateFormat.getInstance((String)formatStr);
            dateFormatMap.put(formatStr, df);
        }
        return df;
    }

    public static Date getDate() {
        return Calendar.getInstance().getTime();
    }

    public static Date getDate(String dateTimeStr, String formatStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(formatStr);
            return sdf.parse(dateTimeStr);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date convertDate(String dateTimeStr) {
        try {
            if (dateTimeStr == null || dateTimeStr.equals("")) {
                return null;
            }
            FastDateFormat sdf = DateUtil.getDateFormat(YYYY_MM_DD);
            Date d = sdf.parse(dateTimeStr);
            return d;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date getDate(String dateTimeStr) {
        return DateUtil.getDate(dateTimeStr, YYYY_MM_DD);
    }

    public static String dateToDateString(Date date) {
        return DateUtil.dateToDateString(date, YYYY_MM_DD_HH_MM_SS);
    }

    public static String stringToDateString(String date, String formatStr1, String formatStr2) {
        Date d = DateUtil.getDate(date, formatStr1);
        FastDateFormat df = DateUtil.getDateFormat(formatStr2);
        return df.format(d);
    }

    public static String getCurDate() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD);
    }

    public static String getCurDate(String formatStr) {
        return DateUtil.dateToDateString(new Date(), formatStr);
    }

    public static String getCurDateTime() {
        return DateUtil.dateToDateString(new Date(), YYYY_MM_DD_HH_MM_SS);
    }

    public static long compareDateStr(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_SSS);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_SSS);
        return d2.getTime() - d1.getTime();
    }

    public static long compareDateMinute(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS_SSS);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS_SSS);
        long time = d2.getTime() - d1.getTime();
        return time / 60000L;
    }

    public static long compareDateDay(String time1, String time2) {
        Date d1 = DateUtil.getDate(time1, YYYY_MM_DD_HH_MM_SS);
        Date d2 = DateUtil.getDate(time2, YYYY_MM_DD_HH_MM_SS);
        long time = d2.getTime() - d1.getTime();
        return time / 86400000L;
    }

    public static Integer getMinuToMill(Integer minutes) {
        if (null == minutes) {
            return null;
        }
        return minutes * 60;
    }

    public static Long getTheDateBegin(String date) {
        date = date + " 00:00:00";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS).getTime();
    }

    public static Long getTheDateEnd(String date) {
        date = date + " 23:59:59";
        return DateUtil.getDate(date, YYYY_MM_DD_HH_MM_SS).getTime();
    }

    public static Long getTheDateBegin(Date date) {
        return DateUtil.getTheDateBegin(DateUtil.dateToDateString(date, YYYY_MM_DD));
    }

    public static Date getDateBegin(Date date) {
        return new Date(DateUtil.getTheDateBegin(date));
    }

    public static Long getTheDateEnd(Date date) {
        return DateUtil.getTheDateEnd(DateUtil.dateToDateString(date, YYYY_MM_DD));
    }

    public static Date getDateEnd(Date date) {
        return new Date(DateUtil.getTheDateEnd(date));
    }

    public static String timeTosec(String time) {
        if ("null".equals(time) || StringUtils.isEmpty((CharSequence)time)) {
            return null;
        }
        if (time.length() <= 5) {
            time = time + ":00";
        }
        int index1 = time.indexOf(":");
        int index2 = time.indexOf(":", index1 + 1);
        int hh = Integer.parseInt(time.substring(0, index1));
        int mi = Integer.parseInt(time.substring(index1 + 1, index2));
        int ss = Integer.parseInt(time.substring(index2 + 1));
        return hh * 60 * 60 + mi * 60 + ss + "";
    }

    public static String secToTime(String timeStr) {
        if (StringUtils.isEmpty((CharSequence)timeStr)) {
            return null;
        }
        int time = Integer.parseInt(timeStr);
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = DateUtil.unitFormat(hour) + ":" + DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        }
        return timeStr;
    }

    public static Integer getSecToMinu(Integer second) {
        if (null == second) {
            return null;
        }
        return second / 60;
    }

    public static String secToMinu(Integer second) {
        if (null == second) {
            return "";
        }
        return second / 60 + "\u5206\u949f";
    }

    public static String secToTime(int time) {
        String timeStr = null;
        int hour = 0;
        int minute = 0;
        int second = 0;
        if (time <= 0) {
            return "00:00";
        }
        minute = time / 60;
        if (minute < 60) {
            second = time % 60;
            timeStr = DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        } else {
            hour = minute / 60;
            if (hour > 99) {
                return "99:59:59";
            }
            second = time - hour * 3600 - (minute %= 60) * 60;
            timeStr = DateUtil.unitFormat(hour) + ":" + DateUtil.unitFormat(minute) + ":" + DateUtil.unitFormat(second);
        }
        return timeStr;
    }

    public static String unitFormat(int i) {
        String retStr = null;
        retStr = i >= 0 && i < 10 ? "0" + i : "" + i;
        return retStr;
    }

    public static long getStrToLong(String timeStr, String format) {
        return DateUtil.getDate(timeStr, format).getTime();
    }

    public static boolean isTimeBefor(Date nows, Date date) {
        long hous = nows.getTime() - date.getTime();
        return hous > 0L;
    }

    public static long getMicroSec(BigDecimal hours) {
        BigDecimal bd = hours.multiply(new BigDecimal(3600000));
        return bd.longValue();
    }

    public static String getDateStringOfYear(int years, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(1, years);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfMon(int months, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(2, months);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfDay(int days, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(5, days);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static boolean theDateIsToday(String date, String format) {
        String theDate = DateUtil.stringToDateString(date, format, YYYYMMDD);
        String today = DateUtil.getDateStringOfDay(0, YYYYMMDD);
        return theDate.equals(today);
    }

    public static String getDateStringOfHour(int hours, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(11, hours);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateOfMin(String date, int mins, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(DateUtil.getDate(date, formatStr));
        now.add(13, mins * 60);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateStringOfMin(int mins, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(12, mins);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static Date getDateOfMin(int mins) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(12, mins);
        return now.getTime();
    }

    public static String getDateStringOfSec(int sec, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(new Date());
        now.add(13, sec);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static String getDateOfSec(String date, int sec, String formatStr) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(DateUtil.getDate(date, formatStr));
        now.add(13, sec);
        return DateUtil.dateToDateString(now.getTime(), formatStr);
    }

    public static int getMonthDay(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.getActualMaximum(5);
    }

    public static int getCurentMonthDay() {
        Date date = Calendar.getInstance().getTime();
        return DateUtil.getMonthDay(date);
    }

    public static int getMonthDay(String date) {
        Date strDate = DateUtil.getDate(date, YYYY_MM_DD);
        return DateUtil.getMonthDay(strDate);
    }

    public static int getYear(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(1);
    }

    public static int getMonth(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(2) + 1;
    }

    public static int getDay(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(5);
    }

    public static int getHour(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(11);
    }

    public static int getMin(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(12);
    }

    public static int getSecond(Date d) {
        Calendar now = Calendar.getInstance(TimeZone.getDefault());
        now.setTime(d);
        return now.get(13);
    }

    public static String getMondayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return DateUtil.dateToDateString(c.getTime(), YYYY_MM_DD);
    }

    public static Date getMondayDateOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 1);
        return c.getTime();
    }

    public static String getSundayOfThisWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + 7);
        return DateUtil.dateToDateString(c.getTime());
    }

    public static String getDayOfThisWeek(int num) {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        c.add(5, -day_of_week + num);
        return DateUtil.dateToDateString(c.getTime(), YYYY_MM_DD);
    }

    public static long getQuotByDays(String beginDate, String endDate) {
        long quot = 0L;
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD);
        try {
            Date d1 = df.parse(beginDate);
            Date d2 = df.parse(endDate);
            quot = d2.getTime() - d1.getTime();
            quot = quot / 1000L / 60L / 60L / 24L;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return quot;
    }

    public static int getQuotByDays(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return days;
    }

    public static String getDateAddDay(String date, int days) {
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD);
        try {
            Calendar cal = Calendar.getInstance();
            cal.setTime(df.parse(date));
            cal.add(5, days);
            date = df.format(cal.getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return date;
    }

    public static Date getDateAddDay(Date date, int days) {
        Calendar no = Calendar.getInstance();
        no.setTime(date);
        no.add(5, days);
        return no.getTime();
    }

    public static String getYesterday(Date date) throws ParseException {
        FastDateFormat df = DateUtil.getDateFormat(YYYY_MM_DD);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(df.parse(df.format(date)));
        calendar.add(5, -1);
        return df.format(calendar.getTime());
    }

    public static Date getFirstDayOfCurrMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date getLastDayOfCurrMonth() {
        Calendar cal = Calendar.getInstance();
        cal.add(2, 1);
        cal.set(5, 0);
        return cal.getTime();
    }

    public static String getIntToStr(String dateInt, String format) {
        FastDateFormat df = DateUtil.getDateFormat(format);
        long times = (long)Integer.parseInt(dateInt) * 1000L;
        Date date = new Date(times);
        return df.format(date);
    }

    public static String getNowTime(String format) {
        FastDateFormat df = DateUtil.getDateFormat(format);
        long times = System.currentTimeMillis();
        Date date = new Date(times);
        return df.format(date);
    }

    public static long getTenTime() {
        return System.currentTimeMillis() / 1000L;
    }

    public static String getMillsStr(long time) {
        String timeStr = String.valueOf(time);
        String suffix = timeStr.substring(0, timeStr.length() - 3);
        String prefix = timeStr.substring(timeStr.length() - 3);
        return suffix + "." + prefix;
    }

    public static Long getTodayTime() {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Date getDateStartTime(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 0);
        dateStart.set(12, 0);
        dateStart.set(13, 0);
        dateStart.set(14, 0);
        return dateStart.getTime();
    }

    public static Long getDateStartTimeStamp(Date date) {
        Calendar dateStart = Calendar.getInstance();
        dateStart.setTime(date);
        dateStart.set(11, 0);
        dateStart.set(12, 0);
        dateStart.set(13, 0);
        dateStart.set(14, 0);
        return dateStart.getTime().getTime();
    }

    public static int getTodayOfWeek() {
        Calendar c = Calendar.getInstance();
        int day_of_week = c.get(7) - 1;
        if (day_of_week == 0) {
            day_of_week = 7;
        }
        return day_of_week;
    }

    public static Integer getTodayInt() {
        return (int)(DateUtil.getTodayTime() / 1000L);
    }

    public static Long getEndTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getStartTime() {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.set(11, 0);
        todayEnd.set(12, 0);
        todayEnd.set(13, 0);
        todayEnd.set(14, 0);
        return todayEnd.getTime().getTime();
    }

    public static Long getEndTime(Date date) {
        Calendar todayEnd = Calendar.getInstance();
        todayEnd.setTime(date);
        todayEnd.set(11, 23);
        todayEnd.set(12, 59);
        todayEnd.set(13, 59);
        todayEnd.set(14, 999);
        return todayEnd.getTime().getTime();
    }

    public static Long getStartTime(Date date) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.setTime(date);
        todayStart.set(11, 0);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static Date getTodayEndTime() {
        return new Date(DateUtil.getEndTime());
    }

    public static Date getTodayStartTime() {
        return new Date(DateUtil.getStartTime());
    }

    public static Integer getTomorrowInt() {
        return (int)(DateUtil.getTomorrowTime() / 1000L);
    }

    public static Long getTomorrowTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, 1);
        return cal.getTime().getTime();
    }

    public static String longToString(String timeStr, String format) {
        long times = Long.parseLong(timeStr.replace(".", ""));
        return DateUtil.longToStr(times, format);
    }

    public static String longToStr(long times, String format) {
        Date date = new Date(times);
        return DateUtil.dateToDateString(date, format);
    }

    public static Long getPointHourTime(int hour) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.set(10, hour);
        todayStart.set(12, 0);
        todayStart.set(13, 0);
        todayStart.set(14, 0);
        return todayStart.getTime().getTime();
    }

    public static boolean isDate(String dateTimeStr, String formatStr) {
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        try {
            df.parse(dateTimeStr);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String dateStrFormat(String dateStr, String formatStr) {
        FastDateFormat df = DateUtil.getDateFormat(formatStr);
        try {
            return df.format(df.parse(dateStr));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int getWeekOfYear(Date d) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault());
        calendar.setTime(d);
        return calendar.get(3);
    }

    public static Date getPointHourDate(int hour) {
        Calendar todayStart = Calendar.getInstance();
        todayStart.add(10, hour);
        return todayStart.getTime();
    }

    public static boolean isTheSameDay(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(d1);
        c2.setTime(d2);
        return c1.get(1) == c2.get(1) && c1.get(2) == c2.get(2) && c1.get(5) == c2.get(5);
    }

    public static List<Date> getDayListOfMouth(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        int mouth = instance.get(2);
        int year = instance.get(1);
        int actualMaxDate = instance.getActualMaximum(5);
        instance.setTime(new Date());
        int currentMouth = instance.get(2);
        int currentDay = instance.get(5);
        ArrayList dates = Lists.newArrayList();
        for (int i = 1; i <= actualMaxDate; ++i) {
            Calendar calendar = Calendar.getInstance();
            if (mouth == currentMouth && i > currentDay) {
                return dates;
            }
            calendar.set(year, mouth, i);
            dates.add(calendar.getTime());
        }
        return dates;
    }

    public static Date getStartTime(Date date, Integer addDayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (addDayOfMonth != null) {
            calendar.add(5, addDayOfMonth);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndTime(Date date, Integer addDayOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (addDayOfMonth != null) {
            calendar.add(5, addDayOfMonth);
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getMondayStartTime(Date date, Integer addWeekOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (addWeekOfMonth != null) {
            calendar.add(4, addWeekOfMonth);
        }
        return calendar.getTime();
    }

    public static Date getSundayStartTime(Date date, Integer addWeekOfMonth) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setFirstDayOfWeek(2);
        calendar.set(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        if (addWeekOfMonth != null) {
            calendar.add(4, addWeekOfMonth);
        }
        return calendar.getTime();
    }

    public static Date getMonthStartTime(Date date, Integer addMonthOfYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        if (addMonthOfYear != null) {
            calendar.add(2, addMonthOfYear);
        }
        return calendar.getTime();
    }

    public static Date getMonthEndTime(Date date, Integer addMonthOfYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        if (addMonthOfYear != null) {
            calendar.add(2, addMonthOfYear);
        }
        return calendar.getTime();
    }

    public static boolean isWithinWeekRange(Date startTime, Date endTime) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startTime);
        startCal.setFirstDayOfWeek(2);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endTime);
        endCal.setFirstDayOfWeek(2);
        int startWeek = startCal.get(3);
        int endWeek = endCal.get(3);
        int startDay = startCal.get(7);
        int endDay = endCal.get(7);
        return startWeek == endWeek && startDay == 2 && endDay == 1;
    }

    public static boolean isWithinMonthRange(Date startTime, Date endTime) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(startTime);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(endTime);
        int year1 = cal1.get(1);
        int month1 = cal1.get(2);
        int day1 = cal1.get(5);
        int year2 = cal2.get(1);
        int month2 = cal2.get(2);
        int day2 = cal2.get(5);
        int lastDayOfMonth = cal2.getActualMaximum(5);
        return year1 == year2 && month1 == month2 && day1 == 1 && day2 == lastDayOfMonth;
    }

    public static Date asDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDateTime asLocalDateTime(String dateTimeStr) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeStr, DateTimeFormatter.ISO_ZONED_DATE_TIME);
        return zonedDateTime.toLocalDateTime();
    }

    public static Date getMinUnixDate() {
        return new Date(0L);
    }

    public static long currentUnixTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public static long date2UnixTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date UnixTimestamp2Date(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static Date getCurrentDate() {
        Calendar today = Calendar.getInstance();
        today.set(today.get(1), today.get(2), today.get(5), 0, 0, 0);
        Date date = new Date();
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static String getToday() {
        return DateUtil.getDayStr(new Date());
    }

    public static String getYesterday() {
        return DateUtil.getDayStr(DateUtil.getDayDiff(-1));
    }

    public static Date getFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2), 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getNextMonthFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2) + 1, 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static Date getPreMonthFirstDate(Date date) {
        Calendar today = Calendar.getInstance();
        today.setTime(date);
        today.set(today.get(1), today.get(2) - 1, 1, 0, 0, 0);
        date.setTime(today.getTimeInMillis() / 1000L * 1000L);
        return date;
    }

    public static String getChineseWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return chineseWeekDayMap.get(cl.get(7));
    }

    public static Integer getWeekDay(Date date) {
        Calendar cl = Calendar.getInstance();
        cl.setTime(date);
        return cl.get(7) - 1;
    }

    public static Date getLastHourDate() {
        Calendar today = Calendar.getInstance();
        today.set(10, today.get(10) - 1);
        return today.getTime();
    }

    public static Date getDayDiff(int diff) {
        Calendar today = Calendar.getInstance();
        today.set(today.get(1), today.get(2), today.get(5) + diff, 0, 0, 0);
        return today.getTime();
    }

    public static Date getDiffDateTime(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, diff);
        return calendar.getTime();
    }

    public static Date getDiffDate(Date date, int diff) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) + diff, 0, 0, 0);
        return calendar.getTime();
    }

    public static Date getDiffDateTime(Date date, int diff, int field) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(field, diff);
        return calendar.getTime();
    }

    public static boolean whetherInTheAm(Date date) {
        GregorianCalendar ca = new GregorianCalendar();
        ca.setTime(date);
        return ca.get(9) == 0;
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return today.get(1) == calendar.get(1) && today.get(2) == calendar.get(2) && today.get(5) == calendar.get(5);
    }

    public static int getThisYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1);
    }

    public static int getThisMonth() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1;
    }

    public static String getDayStr(Date date) {
        return DateUtil.getStrByDateFormat(date, YYYYMMDD);
    }

    public static String getSec(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return String.valueOf(calendar.get(13));
    }

    public static Date getDateByYearMonth(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month - 1, 1);
        return calendar.getTime();
    }

    public static int getMonthDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        return (c2.get(1) - c1.get(1)) * 12 + (c2.get(2) - c1.get(2));
    }

    public static int getDateDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(days));
    }

    public static int getMinuteDiff(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        long time1 = c1.getTimeInMillis();
        long time2 = c2.getTimeInMillis();
        long minutes = (time2 - time1) / 60000L;
        return Integer.parseInt(String.valueOf(minutes));
    }

    public static Date getStrToDate(String format, String str) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        simpleDateFormat.applyPattern(format);
        try {
            return simpleDateFormat.parse(str);
        }
        catch (ParseException var4) {
            var4.printStackTrace();
            return null;
        }
    }

    public static Date getDateByStr(String date) {
        return DateUtil.getStrToDate(YYYY_MM_DD, date);
    }

    public static String getStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(YYYY_MM_DD);
        String str = dateformat1.format(date);
        return str;
    }

    public static String getStrByDateFormat(Date date, String format) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(format);
        String str = dateformat1.format(date);
        return str;
    }

    public static Date getOffSetDate(Date date, int offSet) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static Date getOffSetDate(int offSet) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, offSet);
        return cal.getTime();
    }

    public static int dateCompare(Date startDate, Date endDate) {
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        long startTime = start.getTimeInMillis() / 1000L;
        long endTime = end.getTimeInMillis() / 1000L;
        if (startTime < endTime) {
            return 1;
        }
        return startTime > endTime ? -1 : 0;
    }

    public static List<Date> getDateBetween(Date startDate, Date endDate) {
        Date date;
        ArrayList<Date> dates = new ArrayList<Date>();
        Calendar start = Calendar.getInstance();
        Calendar end = Calendar.getInstance();
        start.setTime(startDate);
        end.setTime(endDate);
        start.set(start.get(1), start.get(2), start.get(5), 0, 0, 0);
        end.set(end.get(1), end.get(2), end.get(5), 0, 0, 0);
        Calendar current = start;
        while (DateUtil.dateCompare(current.getTime(), end.getTime()) > 0) {
            date = new Date();
            date.setTime(current.getTimeInMillis() / 1000L * 1000L);
            dates.add(date);
            current.add(5, 1);
        }
        date = new Date();
        date.setTime(current.getTimeInMillis() / 1000L * 1000L);
        dates.add(date);
        current.add(5, 1);
        return dates;
    }

    public static List<Date> getDateRange(Date startTime, Date currentTime) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startTime);
        startCal.set(11, 0);
        startCal.set(12, 0);
        startCal.set(13, 0);
        startCal.set(14, 0);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(currentTime);
        endCal.set(11, 0);
        endCal.set(12, 0);
        endCal.set(13, 0);
        endCal.set(14, 0);
        ArrayList<Date> dateList = new ArrayList<Date>();
        while (!startCal.after(endCal)) {
            dateList.add(startCal.getTime());
            startCal.add(5, 1);
        }
        return dateList;
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getBeginOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static String getCurrentYM() {
        Date date = new Date();
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyyMM");
        String str = dateformat1.format(date);
        return str;
    }

    public static void main(String[] args) throws Exception {
        Date date = DateUtil.getBeginOfDay(new Date());
        Date yesterday = DateUtil.getBeginOfDay(DateUtil.getDiffDate(new Date(), -1));
        System.out.println("beginOfToday:" + date + "  yesterday:" + yesterday + " diff:" + DateUtil.getDateDiff(yesterday, date));
    }

    public static String getHHMMStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat(HH_MM);
        String str = dateformat1.format(date);
        return str;
    }

    public static String getYYMMDDHHMMStrByDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateformat1 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String str = dateformat1.format(date);
        return str;
    }

    public static String getHHMMStrByTime(long time) {
        Date date = new Date(time);
        return DateUtil.getHHMMStrByDate(date);
    }

    public static int getMonthDay(long time) {
        Date date = new Date(time);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static Date getYearFirst(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        Date currYearFirst = calendar.getTime();
        return currYearFirst;
    }

    public static Date getYearLast(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, year);
        calendar.roll(6, -1);
        Date currYearLast = calendar.getTime();
        return currYearLast;
    }

    public static List<Long> betweenDays(Date startTime, Date endTime) {
        ArrayList<Long> times = new ArrayList<Long>();
        times.add(startTime.getTime());
        Calendar calBegin = Calendar.getInstance();
        calBegin.setTime(startTime);
        Calendar calEnd = Calendar.getInstance();
        calEnd.setTime(endTime);
        while (endTime.after(calBegin.getTime())) {
            calBegin.add(5, 1);
            if (!endTime.after(calBegin.getTime())) continue;
            times.add(calBegin.getTime().getTime());
        }
        return times;
    }

    public static Date addMin(Date startTime, Integer addMin) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(12, addMin);
        return calendar.getTime();
    }

    public static Date addDay(Date startTime, Integer addDay) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startTime);
        calendar.add(6, addDay);
        return calendar.getTime();
    }

    public static boolean isHourAndMin(String input) {
        if (StringUtils.isBlank((CharSequence)input)) {
            return false;
        }
        String pattern = "^([01]\\d|2[0-3]):([0-5]\\d)$";
        return Pattern.matches(pattern, input);
    }

    public static Date convertDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static List<Date> getNextWeekDay(int quantity, Date startTime, Set<Integer> weekDays) {
        ArrayList<Date> result = new ArrayList<Date>();
        LocalDate currentDate = LocalDate.now();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(startTime.toInstant(), ZoneId.systemDefault());
        LocalTime fixedTime = localDateTime.toLocalTime();
        LocalDateTime currentDateTime = LocalDateTime.now();
        int count = 0;
        while (count < quantity) {
            int currentWeekDay = currentDate.getDayOfWeek().getValue();
            LocalDateTime dateTime = LocalDateTime.of(currentDate, fixedTime);
            if (dateTime.isAfter(currentDateTime) && weekDays.contains(currentWeekDay)) {
                result.add(DateUtil.convertDate(dateTime));
                ++count;
            }
            currentDate = currentDate.plusDays(1L);
        }
        return result;
    }

    public static boolean isCurrentDateBetween(Date startDate, Date endDate) {
        Date currentDateTime = new Date();
        return currentDateTime.after(startDate) && currentDateTime.before(endDate);
    }

    public static boolean isDateBetween(Date queryData, Date startDate, Date endDate) {
        return queryData.after(startDate) && queryData.before(endDate);
    }

    public static Long getDurationSecondBetween(Date startDate, Date endDate) {
        LocalDateTime startTime = startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime endTime = endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        Duration duration = Duration.between(startTime, endTime);
        return duration.getSeconds();
    }

    public static String convertSecondToTimeStr(Integer duration) {
        if (duration == null || duration <= 0) {
            return "00\u520600\u79d2";
        }
        StringBuilder sb = new StringBuilder();
        int hour = duration / 3600;
        int remainder = duration % 3600;
        int minute = remainder / 60;
        int second = remainder % 60;
        if (hour > 0) {
            sb.append(hour).append("\u5c0f\u65f6");
        }
        if (minute > 0) {
            sb.append(minute).append("\u5206\u949f");
        }
        if (second > 0) {
            sb.append(second).append("\u79d2");
        }
        return sb.toString();
    }

    public static long gapTimeStamp(int gapMinutes) {
        return ONE_MINUTE_MILLIS * (long)gapMinutes;
    }

    static {
        chineseWeekDayMap.put(2, "\u4e00");
        chineseWeekDayMap.put(3, "\u4e8c");
        chineseWeekDayMap.put(4, "\u4e09");
        chineseWeekDayMap.put(5, "\u56db");
        chineseWeekDayMap.put(6, "\u4e94");
        chineseWeekDayMap.put(7, "\u516d");
        chineseWeekDayMap.put(1, "\u65e5");
    }
}

