/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DESUtil {
    private static final Logger log = LoggerFactory.getLogger(DESUtil.class);

    private DESUtil() {
    }

    public static String encrypt(String srcStr, Charset charset, String sKey) throws GeneralSecurityException {
        byte[] src = srcStr.getBytes(charset);
        byte[] buf = DESUtil.encrypt(src, sKey);
        return DESUtil.parseByte2HexStr(buf);
    }

    public static byte[] encrypt(byte[] data, String sKey) throws GeneralSecurityException {
        byte[] key = sKey.getBytes();
        IvParameterSpec iv = new IvParameterSpec(key);
        DESKeySpec desKey = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        cipher.init(1, (Key)securekey, iv);
        return cipher.doFinal(data);
    }

    public static String decrypt(String hexStr, Charset charset, String sKey) throws GeneralSecurityException {
        byte[] src = DESUtil.parseHexStr2Byte(hexStr);
        byte[] buf = DESUtil.decrypt(src, sKey);
        return new String(buf, charset);
    }

    public static byte[] decrypt(byte[] src, String sKey) throws GeneralSecurityException {
        byte[] key = sKey.getBytes();
        IvParameterSpec iv = new IvParameterSpec(key);
        DESKeySpec desKey = new DESKeySpec(key);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DES");
        SecretKey securekey = keyFactory.generateSecret(desKey);
        Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
        cipher.init(2, (Key)securekey, iv);
        return cipher.doFinal(src);
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (byte b : buf) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sb.append('0');
            }
            sb.append(hex.toUpperCase(Locale.getDefault()));
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.isEmpty()) {
            return new byte[0];
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }
}

