/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.google.common.io.Resources;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.FileCopyUtils;

public class Billboard {
    private static final Logger log = LoggerFactory.getLogger(Billboard.class);
    private BufferedImage canvas;
    private BufferedImage bg;
    private final List<Overlay> list = new ArrayList<Overlay>();
    private final List<TextProps> textPropsList = new ArrayList<TextProps>();
    private static Font customFont;

    public boolean setBackground(String resource) {
        BufferedImage image = Billboard.download(resource);
        return this.setBackground(image);
    }

    public boolean setBackground(BufferedImage img) {
        if (img != null) {
            this.bg = img;
            return true;
        }
        return false;
    }

    public boolean addImage(String resource, int x, int y, int w, int h, boolean round) {
        BufferedImage img = Billboard.download(resource);
        return this.addImage(img, x, y, w, h, round);
    }

    public boolean addImage(BufferedImage img, int x, int y, int w, int h, boolean round) {
        if (img == null) {
            return false;
        }
        Overlay overlay = new Overlay();
        overlay.x = x;
        overlay.y = y;
        overlay.w = w;
        overlay.h = h;
        overlay.originImage = img;
        if (round) {
            img = Billboard.roundCorner(img);
        }
        if (w != img.getWidth() || h != img.getHeight()) {
            double sx = (double)w / (double)img.getWidth();
            double sy = (double)h / (double)img.getHeight();
            img = Billboard.scale(img, sx, sy);
        }
        overlay.scaledImage = img;
        this.list.add(overlay);
        return true;
    }

    public void setTextProp(int x, int y, int fontSize, int red, int green, int blue, int isBold, String text) {
        TextProps textProps = new TextProps();
        textProps.x = x;
        textProps.y = y;
        textProps.fontSize = fontSize;
        textProps.red = red;
        textProps.green = green;
        textProps.blue = blue;
        textProps.text = text;
        textProps.isBold = isBold;
        this.textPropsList.add(textProps);
    }

    public void clearTextProps() {
        this.textPropsList.clear();
    }

    public BufferedImage create() {
        int width = this.bg.getWidth();
        int height = this.bg.getHeight();
        log.info("bg.type={}", (Object)this.bg.getType());
        if (this.canvas == null || this.canvas.getWidth() != width || this.canvas.getHeight() != height) {
            this.canvas = new BufferedImage(width, height, 4);
        }
        Graphics2D g2 = this.canvas.createGraphics();
        g2.drawImage((Image)this.bg, 0, 0, null);
        for (Overlay o : this.list) {
            BufferedImage img = o.scaledImage;
            g2.drawImage(img, o.x, o.y, o.w, o.h, null);
        }
        Font newCustomFont = Billboard.getCustomFont();
        log.info("create customFont: {}", (Object)newCustomFont);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        if (CollectionUtils.isNotEmpty(this.textPropsList)) {
            for (TextProps tp : this.textPropsList) {
                if (newCustomFont == null) continue;
                Font font = newCustomFont.deriveFont(1, tp.fontSize);
                log.info("create font: {}", (Object)font);
                g2.setFont(font);
                Color color = new Color(tp.red, tp.green, tp.blue);
                g2.setColor(color);
                g2.drawString(new String(tp.text.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8), tp.x, tp.y);
            }
        }
        g2.dispose();
        return this.canvas;
    }

    public static Font getCustomFont() {
        if (customFont == null) {
            customFont = Billboard.loadCustomFont();
        }
        return customFont;
    }

    private static Font loadCustomFont() {
        try {
            URL url = Resources.getResource((String)"NotoSansSC-VariableFont_wght.ttf");
            log.info("loadCustomFont url: {}", (Object)url);
            File fontFile = new File(url.getFile());
            if (!fontFile.exists()) {
                InputStream inputStream = Billboard.class.getResourceAsStream("/NotoSansSC-VariableFont_wght.ttf");
                byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)inputStream);
                fontFile = Billboard.createTempFontFile(bytes);
            }
            log.info("loadCustomFont fontFile: {}", (Object)fontFile);
            Font customFont = Font.createFont(0, fontFile);
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            ge.registerFont(customFont);
            return customFont;
        }
        catch (FontFormatException | IOException e) {
            log.error("\u65e0\u6cd5\u52a0\u8f7d\u5b57\u4f53\uff1a" + e.getMessage());
            return null;
        }
    }

    private static File createTempFontFile(byte[] bytes) throws IOException {
        File tempFontFile = File.createTempFile("customFont", ".ttf");
        tempFontFile.deleteOnExit();
        try (FileOutputStream fos = new FileOutputStream(tempFontFile);){
            fos.write(bytes);
        }
        return tempFontFile;
    }

    public boolean saveTo(File file) {
        if (this.canvas == null) {
            this.create();
        }
        try {
            ImageIO.write((RenderedImage)this.canvas, "jpg", file);
            return true;
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58\u6d77\u62a5\u56fe\u7247\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public static BufferedImage roundCorner(BufferedImage input) {
        int width = input.getWidth();
        int height = input.getHeight();
        BufferedImage output = new BufferedImage(width, height, 2);
        Graphics2D g2 = output.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setComposite(AlphaComposite.Clear);
        g2.fill(new Rectangle(width, height));
        g2.setComposite(AlphaComposite.Src);
        g2.fill(new Ellipse2D.Double(0.0, 0.0, width, height));
        g2.setComposite(AlphaComposite.SrcIn);
        g2.drawImage((Image)input, 0, 0, null);
        g2.dispose();
        return output;
    }

    public static BufferedImage scale(BufferedImage in, double sx, double sy) {
        AffineTransform matrix = new AffineTransform();
        matrix.scale(sx, sy);
        AffineTransformOp op = sx < 1.0 && sy < 1.0 ? new AffineTransformOp(matrix, 1) : new AffineTransformOp(matrix, 2);
        int width = (int)((double)in.getWidth() * sx);
        int height = (int)((double)in.getHeight() * sy);
        BufferedImage dstImage = new BufferedImage(width, height, in.getType());
        op.filter(in, dstImage);
        return dstImage;
    }

    public static BufferedImage download(String resource) {
        HttpURLConnection conn;
        URL url;
        BufferedImage image = null;
        long start = System.currentTimeMillis();
        try {
            url = new URL(resource);
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoInput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/33.0.1750.146 Safari/537.36");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
        }
        catch (IOException e) {
            return null;
        }
        try {
            int respCode = conn.getResponseCode();
            if (respCode == 200) {
                InputStream inStream = conn.getInputStream();
                image = ImageIO.read(inStream);
            }
        }
        catch (IOException e) {
            return null;
        }
        conn.disconnect();
        log.info("download image, time: {} ms, url: {}", (Object)(System.currentTimeMillis() - start), (Object)resource);
        return image;
    }

    static final class Overlay {
        int x;
        int y;
        int w;
        int h;
        BufferedImage originImage;
        BufferedImage scaledImage;

        Overlay() {
        }
    }

    static final class TextProps {
        int x;
        int y;
        int red;
        int green;
        int blue;
        int fontSize;
        int isBold;
        String text;

        TextProps() {
        }
    }
}

