/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public final class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    private BeanUtil() {
    }

    public static <T> T convert(Object source, Class<T> clazz, String ... ignoreArgs) {
        if (source == null) {
            return null;
        }
        Preconditions.checkNotNull(clazz, (Object)"clazz\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        try {
            T target = clazz.newInstance();
            BeanUtils.copyProperties((Object)source, target, (String[])ignoreArgs);
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("\u5b9e\u4f8b\u5316\u7c7b\uff1a{}\u5931\u8d25", (Object)clazz.getCanonicalName(), (Object)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> convertToList(Collection<?> sourceList, Class<T> clazz, String ... ignoreArgs) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        return sourceList.stream().map(source -> BeanUtil.convert(source, clazz, ignoreArgs)).collect(Collectors.toList());
    }

    public static <T> Set<T> convertToSet(Collection<?> sourceList, Class<T> clazz, String ... ignoreArgs) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptySet();
        }
        return sourceList.stream().map(source -> BeanUtil.convert(source, clazz, ignoreArgs)).collect(Collectors.toSet());
    }
}

