/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ApplicationContextUtils
implements ApplicationContextAware {
    private static ApplicationContext applicationContext;
    private static Map<String, Object> cacheMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ApplicationContextUtils.applicationContext = applicationContext;
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

    public static Object getBean(String name) {
        return ApplicationContextUtils.getApplicationContext().getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) {
        return (T)ApplicationContextUtils.getApplicationContext().getBean(clazz);
    }

    public static <T> T getBean(String name, Class<T> clazz) {
        return (T)ApplicationContextUtils.getApplicationContext().getBean(name, clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getBean(Class<T> clazz, String suffix) {
        String key = clazz.getCanonicalName() + suffix;
        Object bean = cacheMap.get(key);
        if (Objects.isNull(bean)) {
            String string = key.intern();
            synchronized (string) {
                bean = cacheMap.get(key);
                if (Objects.isNull(bean)) {
                    bean = ApplicationContextUtils.getApplicationContext().getBeansOfType(clazz).entrySet().stream().filter(k -> ((String)k.getKey()).endsWith(suffix)).map(Map.Entry::getValue).findFirst().orElse(null);
                    cacheMap.put(key, bean);
                }
            }
        }
        return (T)bean;
    }

    static {
        cacheMap = Maps.newConcurrentMap();
    }
}

