/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.utils;

import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public final class AESUtil {
    private static final String AES_ALGORITHM = "AES/ECB/PKCS5Padding";
    private static final String AES_256_ALGORITHM = "AES/ECB/PKCS7Padding";

    private AESUtil() {
    }

    public static String encode(String data, String seedKey) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] key = DigestUtils.md5((String)seedKey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(Hex.encodeHexString((byte[])key).getBytes(), "AES");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher decryptor = Cipher.getInstance(AES_256_ALGORITHM, "BC");
        decryptor.init(1, secretKeySpec);
        byte[] byteEncode = data.getBytes(StandardCharsets.UTF_8);
        byte[] byteAES = decryptor.doFinal(byteEncode);
        return new String(Base64.encodeBase64((byte[])byteAES), StandardCharsets.UTF_8);
    }

    public static String decode(String data, String seedKey) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        byte[] key = DigestUtils.md5((String)seedKey);
        SecretKeySpec secretKeySpec = new SecretKeySpec(Hex.encodeHexString((byte[])key).getBytes(), "AES");
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher decryptor = Cipher.getInstance(AES_256_ALGORITHM, "BC");
        decryptor.init(2, secretKeySpec);
        byte[] cipherText = Base64.decodeBase64((String)data);
        byte[] plainText = decryptor.doFinal(cipherText);
        return new String(plainText, StandardCharsets.UTF_8);
    }

    public static byte[] encrypt128(byte[] data, byte[] key) {
        if (data == null) {
            throw new IllegalArgumentException("data must be specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must be specified");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("Invalid AES key length (must be 16 bytes)");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec seckey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(1, seckey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("encrypt fail!", e);
        }
    }

    private static byte[] decrypt128(byte[] data, byte[] key) {
        if (data == null) {
            throw new IllegalArgumentException("data must be specified");
        }
        if (key == null) {
            throw new IllegalArgumentException("key must be specified");
        }
        if (key.length != 16) {
            throw new IllegalArgumentException("Invalid AES key length (must be 16 bytes)");
        }
        try {
            SecretKeySpec secretKey = new SecretKeySpec(key, "AES");
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec seckey = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance(AES_ALGORITHM);
            cipher.init(2, seckey);
            return cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("decrypt fail!", e);
        }
    }

    public static String decrypt256(byte[] data, byte[] key) throws NoSuchPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Cipher cipher = Cipher.getInstance(AES_256_ALGORITHM, "BC");
        cipher.init(2, new SecretKeySpec(key, "AES"));
        return new String(cipher.doFinal(data), StandardCharsets.UTF_8);
    }

    public static String encryptToAES128WithBase64(String data, String key) {
        byte[] valueByte = AESUtil.encrypt128(data.getBytes(StandardCharsets.UTF_8), key.getBytes(StandardCharsets.UTF_8));
        return java.util.Base64.getUrlEncoder().encodeToString(valueByte);
    }

    public static String decryptFromBase64WithAES128(String data, String key) {
        byte[] originalData = java.util.Base64.getUrlDecoder().decode(data);
        byte[] valueByte = AESUtil.decrypt128(originalData, key.getBytes(StandardCharsets.UTF_8));
        return new String(valueByte, StandardCharsets.UTF_8);
    }

    public static String decryptFromBase64WithAES256(String data, String key) {
        try {
            byte[] originalData = java.util.Base64.getUrlDecoder().decode(data);
            return AESUtil.decrypt256(originalData, key.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("decrypt fail!", e);
        }
    }
}

