/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.redis;

import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationPreparedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.data.redis.core.RedisTemplate;

public abstract class RedisVersionedCache {
    private static final Logger log = LoggerFactory.getLogger(RedisVersionedCache.class);
    protected boolean initialized;
    protected String version = "";
    @Autowired
    protected RedisTemplate<String, String> redisTemplate;

    @EventListener(value={ApplicationPreparedEvent.class})
    public void onApplicationPrepared() {
        this.initialized = true;
        this.refresh();
    }

    protected abstract String getVersionRedisKey();

    protected abstract Long getExpire();

    protected abstract TimeUnit getTimeUnit();

    protected abstract void initialize();

    private String initVersion() {
        String redisKey = this.getVersionRedisKey();
        String initVersion = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpire();
            Boolean ok = expire != null && expire > 0L ? this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)initVersion, expire.longValue(), this.getTimeUnit()) : this.redisTemplate.opsForValue().setIfAbsent((Object)redisKey, (Object)initVersion);
            if (ok != null && ok.booleanValue()) {
                log.info("Cache version initialized, key:{}, value:{}, expire:{}", new Object[]{redisKey, initVersion, expire});
            }
        }
        catch (Exception e) {
            log.error("Failed init cache version, key:{}, value:{}", new Object[]{redisKey, initVersion, e});
        }
        return initVersion;
    }

    private String getCurrentVersion() {
        String redisKey = this.getVersionRedisKey();
        String obj = (String)this.redisTemplate.opsForValue().get((Object)redisKey);
        String currentVersion = obj == null ? this.initVersion() : obj;
        return currentVersion;
    }

    protected String reset() {
        String redisKey = this.getVersionRedisKey();
        String newVersion = UUID.randomUUID().toString();
        try {
            Long expire = this.getExpire();
            if (expire != null && expire > 0L) {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)newVersion, expire.longValue(), this.getTimeUnit());
            } else {
                this.redisTemplate.opsForValue().set((Object)redisKey, (Object)newVersion);
            }
            log.info("Set new cache version, key:{}, value:{}, expire:{}", new Object[]{redisKey, newVersion, expire});
        }
        catch (Exception e) {
            log.error("Failed to create new version", (Throwable)e);
        }
        return newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        if (!this.initialized) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)TraceIdUtils.getTraceId())) {
            TraceIdUtils.genAndSetTraceId();
        }
        String currentVersion = this.getCurrentVersion();
        RedisVersionedCache redisVersionedCache = this;
        synchronized (redisVersionedCache) {
            if (this.version.equals(currentVersion)) {
                return;
            }
            this.version = currentVersion;
            long time = System.currentTimeMillis();
            this.initialize();
            time = System.currentTimeMillis() - time;
            log.info("{} cache refreshed in {}ms", (Object)this.getClass().getSimpleName(), (Object)time);
        }
    }
}

