/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.redis;

import com.baijiayun.duanxunbao.common.dto.CommonMsg;
import com.baijiayun.duanxunbao.common.dto.key.IRedisKey;
import com.baijiayun.duanxunbao.common.redis.RedisMsgListener;
import com.baijiayun.duanxunbao.common.redis.RedisVersionedCache;
import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import com.baijiayun.duanxunbao.common.utils.TransactionalUtils;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;

public abstract class RedisMsgVersionedCache
extends RedisVersionedCache
implements RedisMsgListener {
    private static final Logger log = LoggerFactory.getLogger(RedisMsgVersionedCache.class);
    @Value(value="${spring.redis.key.prefix}")
    protected String redisKeyPrefix;

    public void newVersion() {
        TransactionalUtils.doTransactional(() -> {
            String newVersion = super.reset();
            super.refresh();
            CommonMsg msg = new CommonMsg();
            msg.setRequestId(TraceIdUtils.getTraceId());
            msg.setType(this.getType());
            msg.setData(newVersion);
            this.sendMessage(msg);
        });
    }

    public void sendMessage(CommonMsg message) {
        this.redisTemplate.convertAndSend("dxb_redis_topic_refresh_cache", (Object)message);
    }

    @Override
    public void onMessage(CommonMsg message) {
        log.info("\u6536\u5230\u7f13\u5b58\u5237\u65b0\u6d88\u606f:{}", (Object)message);
        super.refresh();
    }

    @Scheduled(fixedRate=30000L)
    public void timer() {
        super.refresh();
    }

    public abstract IRedisKey getRedisKey();

    @Override
    public String getType() {
        return this.getRedisKey().getKey();
    }

    @Override
    protected String getVersionRedisKey() {
        return this.getRedisKey().prefixedKey(this.redisKeyPrefix);
    }

    @Override
    protected Long getExpire() {
        return this.getRedisKey().getExpireTime();
    }

    @Override
    protected TimeUnit getTimeUnit() {
        return this.getRedisKey().getTimeUnit();
    }
}

