/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.redis;

import com.baijiayun.duanxunbao.common.dto.CommonMsg;
import com.baijiayun.duanxunbao.common.redis.RedisMsgListener;
import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class RedisMsgDispatcher
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RedisMsgDispatcher.class);
    private final Map<String, List<RedisMsgListener>> redisMsgListenerMap = new HashMap<String, List<RedisMsgListener>>();

    public void onMessage(CommonMsg message) {
        if (StringUtils.isBlank((CharSequence)message.getRequestId())) {
            TraceIdUtils.genAndSetTraceId();
        } else {
            TraceIdUtils.setTraceId(message.getRequestId());
        }
        List<RedisMsgListener> listeners = this.redisMsgListenerMap.get(message.getType());
        if (CollectionUtils.isEmpty(listeners)) {
            if (log.isDebugEnabled()) {
                log.debug("RedisMsgListener not found, type:{}", (Object)message.getType());
            }
            TraceIdUtils.removeTraceId();
            return;
        }
        for (RedisMsgListener listener : listeners) {
            try {
                listener.onMessage(message);
            }
            catch (Exception e) {
                log.error("RedisMsgListener error, type:{}", (Object)message.getType(), (Object)e);
            }
        }
        TraceIdUtils.removeTraceId();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beans = applicationContext.getBeansOfType(RedisMsgListener.class);
        if (beans.isEmpty()) {
            log.info("No RedisMsgListener found");
            return;
        }
        for (RedisMsgListener listener : beans.values()) {
            List listeners = this.redisMsgListenerMap.computeIfAbsent(listener.getType(), k -> new ArrayList());
            listeners.add(listener);
        }
        log.info("init RedisMsgListener success, redisMsgListeners:{}", this.redisMsgListenerMap);
    }
}

