/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.progress;

import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.dto.TaskProgress;
import com.baijiayun.duanxunbao.common.dto.key.RedisKeyEnum;
import com.baijiayun.duanxunbao.common.enums.ProgressState;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.utils.IdGen;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.baijiayun.duanxunbao.common.utils.NamedThreadFactory;
import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class TaskProgressService {
    private static final Logger log = LoggerFactory.getLogger(TaskProgressService.class);
    public static final Long SLEEP_TIME = 2000L;
    public static final String CURRENT = "current";
    public static final String SUCCESS = "success";
    public static final String FAILED = "failed";
    @Autowired
    private IdGen idGen;
    @Value(value="${spring.redis.key.prefix}")
    private String redisPrefix;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    @Resource
    private RedisTemplate<String, Object> objectRedisTemplate;
    private final ExecutorService executorService = new ThreadPoolExecutor(1, 200, 60L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000), new NamedThreadFactory("redisTaskProgressWatcher"), new ThreadPoolExecutor.DiscardPolicy());

    public Result<String> start(TaskProgress progress) {
        if (progress == null) {
            return Result.error((String)"progress is null");
        }
        if (progress.getId() == null || progress.getId().isEmpty()) {
            progress.setId(this.idGen.getNum());
        }
        progress.setPercentage(Integer.valueOf(0));
        progress.setState(ProgressState.READY.getValue());
        progress.setTimestamp(Long.valueOf(System.currentTimeMillis()));
        progress.setCostTime(Long.valueOf(0L));
        this.refresh(progress);
        Result<Void> result = this.initRedisCurrent(progress.getId());
        if (!result.isSuccess()) {
            return Result.error(result);
        }
        this.setProgressState(progress.getId(), ProgressState.READY);
        log.info("start task progress, id:{}", (Object)progress.getId());
        return Result.ok((String)progress.getId());
    }

    public Result<Void> update(TaskProgress progress) {
        if (progress == null) {
            return Result.error((String)"progress is null");
        }
        if (StringUtils.isBlank((CharSequence)progress.getId())) {
            return Result.error((String)"progress.id is null");
        }
        progress.setState(ProgressState.ONGOING.getValue());
        this.refresh(progress);
        log.info("update task progress:{}", (Object)progress);
        return Result.ok();
    }

    public Result<Void> finish(TaskProgress progress) {
        if (progress == null) {
            return Result.error((String)"progress is null");
        }
        if (StringUtils.isBlank((CharSequence)progress.getId())) {
            return Result.error((String)"progress.id is null");
        }
        progress.setState(ProgressState.FINISHED.getValue());
        this.refresh(progress);
        this.setProgressState(progress.getId(), ProgressState.FINISHED);
        log.info("finish task progress:{}", (Object)progress);
        return Result.ok();
    }

    private void refresh(TaskProgress progress) {
        if (progress.getTotal() != null && progress.getCurrent() != null && progress.getTotal() != 0L) {
            progress.setPercentage(Integer.valueOf((int)(progress.getCurrent() * 100L / progress.getTotal())));
        }
        if (progress.getTimestamp() != null) {
            progress.setCostTime(Long.valueOf(System.currentTimeMillis() - progress.getTimestamp()));
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{progress.getId()});
        this.redisTemplate.opsForValue().set((Object)key, (Object)JacksonUtil.obj2Str(progress), redisKey.getExpireTime(), redisKey.getTimeUnit());
    }

    public Result<TaskProgress> get(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Result.error((ResultError)ResultCode.USER_PARAM_REQUIRED, (String)"id is null");
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        String value = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (value == null) {
            return Result.error((String)("progress not found, id:" + id));
        }
        try {
            TaskProgress taskProgress = JacksonUtil.str2Obj(value, TaskProgress.class);
            return Result.ok((Object)taskProgress);
        }
        catch (IOException e) {
            log.error("progress parse error, id:{}", (Object)id, (Object)e);
            return Result.error((String)("progress parse error, id:" + id));
        }
    }

    public Result<Void> delete(String id) {
        log.info("delete task progress, id:{}", (Object)id);
        if (StringUtils.isBlank((CharSequence)id)) {
            return Result.error((ResultError)ResultCode.USER_PARAM_REQUIRED, (String)"id is null");
        }
        this.redisTemplate.delete((Object)RedisKeyEnum.TASK_PROGRESS.prefixedFormat(this.redisPrefix, new Object[]{id}));
        this.redisTemplate.delete((Object)RedisKeyEnum.TASK_PROGRESS_CURRENT.prefixedFormat(this.redisPrefix, new Object[]{id}));
        this.setProgressState(id, ProgressState.STOP);
        return Result.ok();
    }

    public Result<Void> stop(String id) {
        log.info("stop task progress, id:{}", (Object)id);
        if (StringUtils.isBlank((CharSequence)id)) {
            return Result.error((ResultError)ResultCode.USER_PARAM_REQUIRED, (String)"id is null");
        }
        Result<TaskProgress> progress = this.get(id);
        if (progress.isSuccess()) {
            TaskProgress taskProgress = (TaskProgress)progress.getData();
            taskProgress.setState(ProgressState.STOP.getValue());
            this.refresh(taskProgress);
            this.setProgressState(id, ProgressState.STOP);
            return Result.ok();
        }
        return Result.error(progress);
    }

    public void increaseSuccess(String id, long delta) {
        if (StringUtils.isBlank((CharSequence)id)) {
            log.error("increment SUCCESS error, id:{}", (Object)id);
            return;
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_CURRENT;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        try {
            this.redisTemplate.opsForHash().increment((Object)key, (Object)CURRENT, delta);
            this.redisTemplate.opsForHash().increment((Object)key, (Object)SUCCESS, delta);
            this.redisTemplate.expire((Object)key, redisKey.getExpireTime(), redisKey.getTimeUnit());
        }
        catch (Exception e) {
            log.error("increment SUCCESS error, id:{}", (Object)id, (Object)e);
        }
    }

    public void increaseFailed(String id, long delta) {
        if (StringUtils.isBlank((CharSequence)id)) {
            log.error("increase FAILED error, id:{}", (Object)id);
            return;
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_CURRENT;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        try {
            this.redisTemplate.opsForHash().increment((Object)key, (Object)CURRENT, delta);
            this.redisTemplate.opsForHash().increment((Object)key, (Object)FAILED, delta);
            this.redisTemplate.expire((Object)key, redisKey.getExpireTime(), redisKey.getTimeUnit());
        }
        catch (Exception e) {
            log.error("increment FAILED error, id:{}", (Object)id, (Object)e);
        }
    }

    public Result<Void> initRedisCurrent(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return Result.error((ResultError)ResultCode.USER_PARAM_REQUIRED, (String)"id is null");
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_CURRENT;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        this.objectRedisTemplate.opsForHash().put((Object)key, (Object)CURRENT, (Object)0L);
        this.objectRedisTemplate.opsForHash().put((Object)key, (Object)SUCCESS, (Object)0L);
        this.objectRedisTemplate.opsForHash().put((Object)key, (Object)FAILED, (Object)0L);
        this.objectRedisTemplate.expire((Object)key, redisKey.getExpireTime(), redisKey.getTimeUnit());
        return Result.ok();
    }

    public void setProgressState(String id, ProgressState state) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)id), (Object)"id is null");
        Preconditions.checkArgument((state != null ? 1 : 0) != 0, (Object)"state is null");
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_STATE;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        this.redisTemplate.opsForValue().set((Object)key, (Object)state.getValue(), redisKey.getExpireTime(), redisKey.getTimeUnit());
    }

    public ProgressState getProgressState(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_STATE;
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{id});
        String state = (String)this.redisTemplate.opsForValue().get((Object)key);
        if (StringUtils.isBlank((CharSequence)state)) {
            return null;
        }
        return ProgressState.of((String)state);
    }

    public void startWatcher(TaskProgress progress) {
        log.info("start watcher, taskId:{}", (Object)progress.getId());
        String traceId = TraceIdUtils.getTraceId();
        this.executorService.submit(() -> this.watchRedisProgress(traceId, progress));
    }

    public void watchRedisProgress(String traceId, TaskProgress progress) {
        TraceIdUtils.setTraceId(traceId);
        String taskId = progress.getId();
        long lastValue = -999999999L;
        long timestamp = System.currentTimeMillis();
        RedisKeyEnum redisKey = RedisKeyEnum.TASK_PROGRESS_CURRENT;
        long maxTime = redisKey.getTimeUnit().toMillis(redisKey.getExpireTime());
        String key = redisKey.prefixedFormat(this.redisPrefix, new Object[]{taskId});
        while (progress.getCurrent() < progress.getTotal()) {
            try {
                Thread.sleep(SLEEP_TIME);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Watcher \u7ebf\u7a0b\u5f02\u5e38\u4e2d\u65ad", (Throwable)e);
                break;
            }
            ProgressState state = this.getProgressState(taskId);
            if (ProgressState.STOP == state || ProgressState.FINISHED == state) {
                log.info("\u4efb\u52a1\u5df2\u7ed3\u675f, taskId:{}", (Object)taskId);
                break;
            }
            try {
                long failed;
                Object currentCache = this.objectRedisTemplate.opsForHash().get((Object)key, (Object)CURRENT);
                Object successCache = this.objectRedisTemplate.opsForHash().get((Object)key, (Object)SUCCESS);
                Object failedCache = this.objectRedisTemplate.opsForHash().get((Object)key, (Object)FAILED);
                if (currentCache == null) {
                    log.warn("\u83b7\u53d6\u4efb\u52a1\u8fdb\u5ea6\u5931\u8d25, taskId:{}", (Object)taskId);
                    this.finish(progress);
                    break;
                }
                log.info("\u83b7\u53d6\u4efb\u52a1\u8fdb\u5ea6\u6210\u529f, taskId:{}, total:{}, current:{}, success:{}, failed:{}", new Object[]{taskId, progress.getTotal(), currentCache, successCache, failedCache});
                long current = ((Number)currentCache).longValue();
                long success = successCache == null ? 0L : ((Number)successCache).longValue();
                long l = failed = failedCache == null ? 0L : ((Number)failedCache).longValue();
                if (current != lastValue) {
                    lastValue = current;
                    timestamp = System.currentTimeMillis();
                    progress.setCurrent(Long.valueOf(current));
                    progress.setSuccess(Long.valueOf(success));
                    progress.setFailed(Long.valueOf(failed));
                    if (current < progress.getTotal()) {
                        Result<Void> updateResult = this.update(progress);
                        if (updateResult.isSuccess()) continue;
                        log.error("\u66f4\u65b0\u4efb\u52a1\u8fdb\u5ea6\u5931\u8d25, result:{}", updateResult);
                        break;
                    }
                    this.finish(progress);
                    break;
                }
                if (System.currentTimeMillis() - timestamp <= maxTime) continue;
                log.warn("\u4efb\u52a1\u8fdb\u5ea6\u957f\u65f6\u95f4\u6ca1\u6709\u66f4\u65b0\uff0c\u5f3a\u5236\u7ed3\u675f\u4efb\u52a1, taskId:{}", (Object)taskId);
                this.finish(progress);
            }
            catch (Exception e) {
                log.error("Watcher \u7ebf\u7a0b\u5f02\u5e38\u4e2d\u65ad", (Throwable)e);
                this.finish(progress);
            }
            break;
        }
        log.info("Watcher \u7ebf\u7a0b\u7ed3\u675f, taskId:{}", (Object)taskId);
    }
}

