/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.oss;

import com.aliyun.oss.OSS;
import com.aliyun.oss.OSSClientBuilder;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.sts.AssumeRoleRequest;
import com.aliyuncs.auth.sts.AssumeRoleResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.baijiayun.duanxunbao.common.oss.StsInfo;
import com.baijiayun.duanxunbao.common.utils.DateUtil;
import com.baijiayun.duanxunbao.common.utils.StopWatchDto;
import java.io.File;
import java.io.InputStream;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public final class AliyunOss {
    private static final Logger log = LoggerFactory.getLogger(AliyunOss.class);
    private final String endpoint;
    private final String accessKeyId;
    private final String accessKeySecret;
    private final String roleArn;
    private final String bucket;
    private final long expireDays;

    public AliyunOss(String endpoint, String accessKeyId, String accessKeySecret, String roleArn, String bucket, long expireDays) {
        this.endpoint = endpoint;
        this.accessKeyId = accessKeyId;
        this.accessKeySecret = accessKeySecret;
        this.roleArn = roleArn;
        this.bucket = bucket;
        this.expireDays = expireDays;
    }

    public AssumeRoleResponse getSTS() throws ClientException {
        String roleSessionName = "session-name";
        String policy = "{\n    \"Version\": \"1\", \n    \"Statement\": [\n        {\n            \"Action\": [\n                \"oss:*\"\n            ], \n            \"Resource\": [\n                \"acs:oss:*:*:*\" \n            ], \n            \"Effect\": \"Allow\"\n        }\n    ]\n}";
        try {
            DefaultProfile profile = DefaultProfile.getProfile((String)"cn-shanghai", (String)this.accessKeyId, (String)this.accessKeySecret);
            DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
            AssumeRoleRequest request = new AssumeRoleRequest();
            request.setSysMethod(MethodType.POST);
            request.setSysProtocol(ProtocolType.HTTPS);
            request.setRoleArn(this.roleArn);
            request.setRoleSessionName(roleSessionName);
            request.setPolicy(policy);
            return (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        }
        catch (Exception e) {
            log.error("STS Request Failed", (Throwable)e);
            throw e;
        }
    }

    public StsInfo getStsInfo() throws ClientException {
        StopWatchDto timer = new StopWatchDto("getSTSFromOss", true, log);
        timer.start("getSTSFromOss");
        AssumeRoleResponse assumeRoleResponse = this.getSTS();
        timer.stop();
        timer.print();
        AssumeRoleResponse.Credentials credentials = assumeRoleResponse.getCredentials();
        StsInfo stsInfo = new StsInfo();
        BeanUtils.copyProperties((Object)credentials, (Object)((Object)stsInfo));
        stsInfo.setBucket(this.bucket);
        stsInfo.setEndpoint(this.endpoint);
        return stsInfo;
    }

    private String fileKey(Long bizId, File file, String originFileKey) {
        if (bizId == null) {
            throw new IllegalArgumentException("bizId can not be null or empty");
        }
        String dateStr = DateUtil.dateToDateString(new Date(), "yyyyMMdd");
        String fileDir = "dxb/" + bizId + "/" + dateStr + "/";
        String fileKey = StringUtils.isNotBlank((CharSequence)originFileKey) ? fileDir + originFileKey : fileDir + UUID.randomUUID().toString().replace("-", "") + "-" + file.getName();
        return fileKey;
    }

    public String uploadFile(Long bizId, File file, String originFileKey) {
        String fileKey = this.fileKey(bizId, file, originFileKey);
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ossClient.putObject(this.bucket, fileKey, file);
        ossClient.shutdown();
        return "https://" + this.bucket + '.' + this.endpoint + '/' + fileKey;
    }

    public String uploadFile(String folder, String fileName, InputStream file) {
        String fileKey = folder + '/' + fileName;
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ossClient.putObject(this.bucket, fileKey, file);
        ossClient.shutdown();
        return "https://" + this.bucket + '.' + this.endpoint + '/' + fileKey;
    }

    public String uploadFileWithOriginFileName(Long bizId, File file, String originFileKey, String originFileName) {
        String fileKey = this.fileKey(bizId, file, originFileKey);
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentDisposition("attachment;filename=\"" + originFileName + "\"");
        ossClient.putObject(this.bucket, fileKey, file, objectMetadata);
        ossClient.shutdown();
        return "https://" + this.bucket + '.' + this.endpoint + '/' + fileKey;
    }

    public void delUploadFile(Long bizId, String originFileKey) {
        if (bizId == null) {
            throw new IllegalArgumentException("bizId can not be null or empty");
        }
        if (StringUtils.isBlank((CharSequence)originFileKey)) {
            throw new IllegalArgumentException("originFileKey can not be null or empty");
        }
        OSS ossClient = new OSSClientBuilder().build(this.endpoint, this.accessKeyId, this.accessKeySecret);
        ossClient.deleteObject(this.bucket, originFileKey);
        ossClient.shutdown();
    }
}

