/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.kafka.canal;

import com.baijiayun.duanxunbao.common.kafka.canal.CanalHandler;
import com.baijiayun.duanxunbao.common.kafka.canal.CanalKafkaDataHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public final class CanalKafkaDataHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(CanalKafkaDataHandlerFactory.class);
    private final Map<String, List<CanalKafkaDataHandler>> handlerMap;
    private final boolean empty;

    private CanalKafkaDataHandlerFactory() {
        this.handlerMap = Collections.emptyMap();
        this.empty = true;
    }

    private CanalKafkaDataHandlerFactory(@NonNull Map<String, List<CanalKafkaDataHandler>> handlerMap) {
        if (handlerMap == null) {
            throw new NullPointerException("handlerMap is marked non-null but is null");
        }
        this.handlerMap = handlerMap;
        this.empty = handlerMap.isEmpty();
    }

    public List<CanalKafkaDataHandler> getHandler(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (this.handlerMap.containsKey(tableName)) {
            return this.handlerMap.getOrDefault(tableName, Collections.emptyList());
        }
        if (log.isDebugEnabled()) {
            log.debug("No CanalKafkaDataHandler found for table: {}", (Object)tableName);
        }
        return Collections.emptyList();
    }

    public static CanalKafkaDataHandlerFactory create(@NonNull ApplicationContext context, String groupName) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        log.info("init CanalKafkaDataHandlerFactory");
        List handlers = context.getBeansWithAnnotation(CanalHandler.class).values().stream().filter(CanalKafkaDataHandler.class::isInstance).map(CanalKafkaDataHandler.class::cast).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            log.info("No CanalHandlers found");
            return new CanalKafkaDataHandlerFactory();
        }
        HashMap<String, List<CanalKafkaDataHandler>> handlersMap = new HashMap<String, List<CanalKafkaDataHandler>>();
        for (CanalKafkaDataHandler handler : handlers) {
            CanalHandler annotation = handler.getClass().getAnnotation(CanalHandler.class);
            String[] tables = annotation.table();
            String group = annotation.group();
            if (!StringUtils.equals((CharSequence)groupName, (CharSequence)group)) continue;
            for (String table : tables) {
                Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)table), (Object)"table name can not be blank");
                List handlerList = handlersMap.computeIfAbsent(table, k -> Lists.newArrayList());
                handlerList.add(handler);
            }
        }
        if (MapUtils.isNotEmpty(handlersMap)) {
            for (List handlerList : handlersMap.values()) {
                handlerList.sort((o1, o2) -> {
                    CanalHandler a1 = o1.getClass().getAnnotation(CanalHandler.class);
                    CanalHandler a2 = o2.getClass().getAnnotation(CanalHandler.class);
                    return Integer.compare(a1.order(), a2.order());
                });
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("CanalKafkaDataHandlerFactory init success, handlersMap:{}", handlersMap);
        }
        return new CanalKafkaDataHandlerFactory(handlersMap);
    }

    public boolean isEmpty() {
        return this.empty;
    }
}

