/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.kafka.canal;

import com.baijiayun.duanxunbao.common.dto.CanalKafkaData;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;

public interface CanalKafkaDataHandler {
    default public void sync(Logger log, CanalKafkaData canalKafkaData) {
        String sqlType;
        switch (sqlType = canalKafkaData.getType().toUpperCase(Locale.getDefault())) {
            case "INSERT": {
                this.onBinlogInsert(canalKafkaData);
                break;
            }
            case "UPDATE": {
                this.onBinlogUpdate(canalKafkaData);
                break;
            }
            case "DELETE": {
                this.onBinlogDelete(canalKafkaData);
                break;
            }
            case "TRUNCATE": {
                this.onBinlogTruncate(canalKafkaData);
                break;
            }
            default: {
                log.info("Unsupported sqlType:{}", (Object)sqlType);
            }
        }
    }

    public void onBinlogInsert(CanalKafkaData var1);

    public void onBinlogUpdate(CanalKafkaData var1);

    default public void onBinlogDelete(CanalKafkaData canalKafkaData) {
    }

    default public void onBinlogTruncate(CanalKafkaData canalKafkaData) {
    }

    default public <T> void foreach(Logger log, CanalKafkaData data, Class<T> clazz, Consumer<T> func) {
        for (Map map : data.getData()) {
            try {
                T obj = JacksonUtil.str2Obj(JacksonUtil.obj2Str(map), clazz);
                func.accept(obj);
            }
            catch (Exception e) {
                log.error("Parse {} failed:{}", new Object[]{data.getTable(), map, e});
            }
        }
    }
}

