/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.kafka;

import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.ProducerListener;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Component;
import org.springframework.util.concurrent.ListenableFuture;

@Component
public class KafkaClientUtils {
    private static final Logger log = LoggerFactory.getLogger(KafkaClientUtils.class);
    private KafkaTemplate<String, String> kafkaTemplate;
    private ProducerListener<String, String> producerListener;
    @Autowired
    private ConsumerFactory<String, String> consumerFactory;

    @Autowired
    public KafkaClientUtils(KafkaTemplate<String, String> kafkaTemplate) {
        this.kafkaTemplate = kafkaTemplate;
        this.kafkaTemplate.setProducerListener((ProducerListener)new ProducerListener<String, String>(){

            public void onSuccess(ProducerRecord<String, String> producerRecord, RecordMetadata recordMetadata) {
                if (KafkaClientUtils.this.producerListener != null) {
                    KafkaClientUtils.this.producerListener.onSuccess(producerRecord, recordMetadata);
                }
            }

            public void onError(ProducerRecord<String, String> producerRecord, RecordMetadata recordMetadata, Exception exception) {
                if (KafkaClientUtils.this.producerListener != null) {
                    KafkaClientUtils.this.producerListener.onError(producerRecord, recordMetadata, exception);
                }
                log.error("Kafka send message on error producerRecord: {}", producerRecord, (Object)exception);
            }
        });
    }

    public void setProducerListener(ProducerListener<String, String> producerListener) {
        if (producerListener == null) {
            throw new IllegalArgumentException("ProducerListener must not be null");
        }
        this.producerListener = producerListener;
    }

    public ListenableFuture<SendResult<String, String>> sendMessage(String topic, String key, String data) {
        try {
            return this.kafkaTemplate.send(topic, (Object)key, (Object)data);
        }
        catch (Exception e) {
            log.error("sendMessage exception, e:{}, topic:{}  ", (Object)e, (Object)topic);
            throw e;
        }
    }

    public Consumer<String, String> buildConsumer() {
        return this.consumerFactory.createConsumer();
    }

    public Consumer<String, String> buildConsumer(String groupId, String clientIdSuffix) {
        return this.consumerFactory.createConsumer(groupId, clientIdSuffix);
    }
}

