/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.kafka;

import com.baijiayun.duanxunbao.common.kafka.BaseKafkaConsumerImpl;
import com.baijiayun.duanxunbao.common.kafka.KafkaClientUtils;
import com.baijiayun.duanxunbao.common.kafka.KafkaMsgHandler;
import java.util.Objects;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;

public abstract class AbstractTopicConsumer
extends BaseKafkaConsumerImpl
implements CommandLineRunner,
KafkaMsgHandler<String, String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractTopicConsumer.class);
    @Value(value="${duanxunbao.consumer.enabled:true}")
    private boolean enable;

    @Override
    @Value(value="${duanxunbao.consumer.poll-ms:1000}")
    public void setConsumerPollMs(Integer consumerPollMs) {
        this.consumerPollMs = consumerPollMs;
    }

    @Override
    @Autowired
    public void setKafkaClientUtils(KafkaClientUtils kafkaClientUtils) {
        this.kafkaClientUtils = kafkaClientUtils;
    }

    public void run(String ... args) throws Exception {
        log.info("duanxunbao.consumer.enabled:{}", (Object)this.enable);
        if (Objects.isNull(this.msgHandler)) {
            this.setMsgHandler(this);
        }
        if (this.enable) {
            this.doStart();
        }
    }

    @Override
    public abstract String getTopic();

    @Override
    public void onMessage(ConsumerRecord<String, String> records) {
        this.handle(records);
    }

    public abstract void handle(ConsumerRecord<String, String> var1);
}

