/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.jwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.TokenExpiredException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.dto.key.RedisKeyEnum;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.jwt.JwtToken;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JwtTokenUtil {
    private static final Logger log = LoggerFactory.getLogger(JwtTokenUtil.class);

    private JwtTokenUtil() {
    }

    public static String encryptPassword(String salt, String password) {
        DefaultHashService hashService = new DefaultHashService();
        hashService.setPrivateSalt(ByteSource.Util.bytes((String)"dxb"));
        hashService.setHashAlgorithmName("MD5");
        hashService.setHashIterations(2);
        HashRequest request = new HashRequest.Builder().setSalt((Object)salt).setSource((Object)password).build();
        return hashService.computeHash(request).toHex();
    }

    public static String redisKey(String prefix, JwtToken user) {
        return RedisKeyEnum.LOGIN_USER.prefixedFormat(prefix, new Object[]{user.getUserType(), user.getUserId()});
    }

    public static String createToken(Long userId, Integer userType) {
        JwtToken user = new JwtToken(userId, userType);
        String json = JacksonUtil.obj2Str(user);
        return JwtTokenUtil.createToken(json);
    }

    public static String createToken(JwtToken user) {
        String json = JacksonUtil.obj2Str(user);
        return JwtTokenUtil.createToken(json);
    }

    public static String createToken(String user) {
        Algorithm algorithm = Algorithm.HMAC256((String)"qjN_Iycz2X2!7#hm0qJ7Hq%6rAg&~6)*");
        Date now = new Date();
        return JWT.create().withClaim("user", user).withExpiresAt(DateUtils.addDays((Date)now, (int)30)).sign(algorithm);
    }

    public static Result<JwtToken> getLoginUser(String token) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)"qjN_Iycz2X2!7#hm0qJ7Hq%6rAg&~6)*");
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).build();
            DecodedJWT decodedJWT = verifier.verify(token);
            String user = decodedJWT.getClaim("user").asString();
            JwtToken jwtDto = JacksonUtil.str2Obj(user, JwtToken.class);
            if (jwtDto != null) {
                return Result.ok((Object)jwtDto);
            }
            return Result.error((ResultError)ResultCode.USER_TOKEN_INVALID);
        }
        catch (TokenExpiredException e) {
            return Result.error((ResultError)ResultCode.USER_TOKEN_EXPIRE);
        }
        catch (Exception ex) {
            log.error("token:{} \u5931\u6548\u9700\u4ece\u65b0\u767b\u9646", (Object)token, (Object)ex);
            return Result.error((ResultError)ResultCode.USER_TOKEN_INVALID);
        }
    }

    public static Date drawJwtTokenExpiresAt(String token) {
        return JWT.decode((String)token).getExpiresAt();
    }
}

