/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.filter;

import com.baijiayun.duanxunbao.common.web.utils.CustomHttpServletRequestWrapper;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@WebFilter
public class RequestBodyReserveFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(RequestBodyReserveFilter.class);

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        CustomHttpServletRequestWrapper requestWrapper = null;
        if (servletRequest instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)servletRequest;
            String contentType = req.getContentType();
            if (StringUtils.isNotBlank((CharSequence)contentType) && (contentType.contains("multipart/form-data") || contentType.contains("application/x-www-form-urlencoded"))) {
                if (log.isDebugEnabled()) {
                    log.debug("skip, content-type:{}", (Object)contentType);
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("save request body, content-type:{}", (Object)contentType);
                }
                requestWrapper = new CustomHttpServletRequestWrapper(req);
            }
        }
        if (requestWrapper == null) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter(requestWrapper, servletResponse);
        }
    }
}

