/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.feign;

import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import com.baijiayun.duanxunbao.common.web.utils.SignUtils;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestHeaderInterceptor
implements RequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(RequestHeaderInterceptor.class);

    public void apply(RequestTemplate requestTemplate) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        String requestId = null;
        if (attributes != null) {
            HttpServletRequest request = attributes.getRequest();
            String token = request.getHeader("B-Token");
            requestTemplate.header("B-Token", new String[]{token});
            String deviceType = request.getHeader("B-Device-Type");
            requestTemplate.header("B-Device-Type", new String[]{deviceType});
            requestId = request.getHeader("B-Request-ID");
            if (StringUtils.isBlank((CharSequence)requestId)) {
                requestId = (String)request.getAttribute("B-Request-ID");
            }
        }
        if (requestId == null || requestId.isEmpty()) {
            requestId = TraceIdUtils.getTraceId();
        }
        if (requestId == null || requestId.isEmpty()) {
            requestId = UUID.randomUUID().toString().replace("-", "");
            log.info("Feign init requestId: {}", (Object)requestId);
        }
        requestTemplate.header("B-Request-ID", new String[]{requestId});
        String timestamp = String.valueOf(System.currentTimeMillis());
        TreeMap<String, Collection<String>> allParams = new TreeMap<String, Collection<String>>();
        if (HttpMethod.GET.name().equals(requestTemplate.method())) {
            allParams.putAll(requestTemplate.queries());
        } else {
            String contentType = this.getContentTypeValue(requestTemplate.headers());
            allParams.putAll(SignUtils.getRequestBody(contentType, requestTemplate.body()));
        }
        allParams.put("timestamp", Collections.singletonList(timestamp));
        String sign = SignUtils.getParamsSign(allParams);
        requestTemplate.header("B-Sign", new String[]{sign});
        requestTemplate.header("B-Timestamp", new String[]{timestamp});
    }

    private String getContentTypeValue(Map<String, Collection<String>> headers) {
        Collection<String> values = headers.get("Content-Type");
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.iterator().next();
    }
}

