/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.exception;

import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ConstraintViolationException;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.UnauthorizedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.servlet.NoHandlerFoundException;

@RestControllerAdvice
public class ControllerExceptionAdvice {
    private static final Logger log = LoggerFactory.getLogger(ControllerExceptionAdvice.class);
    @Value(value="${maxUploadSize:-1}")
    private long maxUploadSize;
    @Value(value="${showError:false}")
    boolean showError;

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<?> handlerMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error((int)ResultCode.USER_PARAM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<?> handlerConstraintViolationException(ConstraintViolationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error((int)ResultCode.USER_PARAM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    public Result<?> handleBusinessException(BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error((int)e.getErrorCode().getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={IllegalArgumentException.class})
    public Result<?> handleArgumentException(IllegalArgumentException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error((int)ResultCode.USER_PARAM_ERROR.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public Result<?> handleRequestMethodNotSupported(HttpRequestMethodNotSupportedException exception) {
        log.error(exception.getMessage(), (Throwable)exception);
        return Result.error((ResultError)ResultCode.USER_ERROR);
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<?> handleHttpMessageNotReadableException(HttpMessageNotReadableException exception, HttpServletRequest request) {
        log.error("requestUri:{}, message:{}", new Object[]{request.getRequestURI(), exception.getMessage(), exception});
        return Result.error((ResultError)ResultCode.USER_PARAM_ERROR);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<?> handleMissingServletRequestParameterException(MissingServletRequestParameterException exception, HttpServletRequest request) {
        log.error("requestUri:{}, message:{}", new Object[]{request.getRequestURI(), exception.getMessage(), exception});
        return Result.error((ResultError)ResultCode.USER_PARAM_REQUIRED);
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    public Result<?> handleNoFoundException(NoHandlerFoundException exception, HttpServletRequest request) {
        log.error("requestUri:{}, message:{}", new Object[]{request.getRequestURI(), exception.getMessage(), exception});
        return Result.error((int)404, (String)"\u8def\u5f84\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u8def\u5f84\u662f\u5426\u6b63\u786e");
    }

    @ExceptionHandler(value={UnauthorizedException.class, AuthorizationException.class})
    public Result<?> handleAuthorizationException(AuthorizationException e) {
        log.error(e.getMessage(), (Throwable)e);
        return Result.error((ResultError)ResultCode.USER_NO_AUTH);
    }

    @ExceptionHandler(value={Exception.class})
    public Result<?> handleException(Exception e, HttpServletRequest request, HttpServletResponse response) {
        String requestURI = request.getRequestURI();
        String method = request.getMethod();
        Map parameterMap = request.getParameterMap();
        ImmutableMap map = ImmutableMap.of((Object)"requestURI", (Object)requestURI, (Object)"method", (Object)method, (Object)"requestParam", (Object)parameterMap, (Object)"errorMessage", (Object)(e.getMessage() != null ? e.getMessage() : "null"));
        log.error("============>>>>>  {}", (Object)map, (Object)e);
        return this.handleUndeclaredException(e);
    }

    protected Result<?> handleUndeclaredException(Exception ex) {
        Result result = null;
        if (ex instanceof ClientAbortException) {
            log.warn("ClientAbortException ", (Throwable)ex);
        } else {
            result = ex instanceof IllegalArgumentException ? Result.error((int)ResultCode.USER_PARAM_ERROR.getCode(), (String)ex.getMessage()) : (ex instanceof MaxUploadSizeExceededException ? Result.error((int)ResultCode.USER_PARAM_ERROR.getCode(), (String)"\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236") : Result.error((ResultError)ResultCode.SYSTEM_ERROR));
        }
        if (result != null) {
            log.info("response error: {}", (Object)JacksonUtil.obj2Str(result));
        }
        return result;
    }
}

