/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.es;

import com.baijiayun.duanxunbao.common.dto.PageDto;
import com.baijiayun.duanxunbao.common.dto.Result;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.baijiayun.duanxunbao.common.utils.TraceIdUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.storedscripts.PutStoredScriptRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EsWrapper<T> {
    private static final Logger log = LoggerFactory.getLogger(EsWrapper.class);
    private final RestHighLevelClient restHighLevelClient;

    public static <T> EsWrapper<T> of(RestHighLevelClient restHighLevelClient) {
        return new EsWrapper<T>(restHighLevelClient);
    }

    private EsWrapper(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    private String getId(T model, Function<T, ?> function) {
        Object val = function.apply(model);
        if (val != null) {
            return String.valueOf(val);
        }
        return null;
    }

    public Result<Void> putScript(String id, String script) {
        AcknowledgedResponse response;
        PutStoredScriptRequest request = new PutStoredScriptRequest();
        request.id(id);
        try (XContentBuilder builder = XContentFactory.jsonBuilder();){
            builder.startObject();
            builder.startObject("script");
            builder.field("lang", "painless");
            builder.field("source", script);
            builder.endObject();
            builder.endObject();
            request.content(BytesReference.bytes((XContentBuilder)builder), XContentType.JSON);
            response = this.restHighLevelClient.putScript(request, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            log.error("putScript failed, id:{}", (Object)id, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)("storeScript failed, id:" + id));
        }
        if (!response.isAcknowledged()) {
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)("storeScript failed, id:" + id));
        }
        log.info("storeScript success, id:{}", (Object)id);
        return Result.ok();
    }

    public Result<Void> index(String index, T model, Function<T, ?> function) {
        log.info("index, {}, model:{}", (Object)index, model);
        if (model == null) {
            log.info("model is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"model is null");
        }
        String id = this.getId(model, function);
        if (id == null) {
            log.warn("id is null, model:{}", model);
        }
        Map<String, Object> map = JacksonUtil.toMap(model);
        IndexRequest indexRequest = new IndexRequest(index).id(id);
        indexRequest.source(map, XContentType.JSON);
        indexRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        try {
            long time = System.currentTimeMillis();
            this.restHighLevelClient.index(indexRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "index", time);
        }
        catch (IOException e) {
            log.error("index {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"index failed");
        }
        return Result.ok();
    }

    public Result<Void> indexAsync(final String index, final T model, Function<T, ?> function) {
        log.info("indexAsync, {}, model:{}", (Object)index, model);
        if (model == null) {
            log.info("model is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"model is null");
        }
        String id = this.getId(model, function);
        if (id == null) {
            log.warn("id is null, model:{}", model);
        }
        Map<String, Object> map = JacksonUtil.toMap(model);
        IndexRequest indexRequest = new IndexRequest(index).id(id);
        indexRequest.source(map, XContentType.JSON);
        try {
            final long time = System.currentTimeMillis();
            this.restHighLevelClient.indexAsync(indexRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<IndexResponse>(){

                public void onResponse(IndexResponse indexResponse) {
                    log.info("insert success:{}", model);
                    EsWrapper.this.logCostTime(index, "insertAsync", time);
                }

                public void onFailure(Exception e) {
                    log.error("insert failed:{}", model, (Object)e);
                    EsWrapper.this.logCostTime(index, "insertAsync", time);
                }
            });
        }
        catch (Exception e) {
            log.error("indexAsync {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"indexAsync failed");
        }
        return Result.ok();
    }

    public Result<Void> update(String index, T model, Function<T, ?> function) {
        return this.update(index, model, function, true);
    }

    public Result<Void> update(String index, T model, Function<T, ?> function, boolean ignoreNull) {
        log.info("update, {}, ignoreNull:{}", (Object)index, (Object)ignoreNull);
        if (model == null) {
            log.info("model is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"model is null");
        }
        String id = this.getId(model, function);
        if (id == null) {
            log.warn("id is null, model:{}", model);
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"id is null");
        }
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        Map map = JacksonUtil.toMap(model);
        if (ignoreNull) {
            map = Maps.filterValues(map, Objects::nonNull);
        }
        log.info("update model:{}", (Object)map);
        updateRequest.doc(map, XContentType.JSON);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        updateRequest.retryOnConflict(3);
        try {
            long time = System.currentTimeMillis();
            this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "update", time);
        }
        catch (IOException e) {
            log.error("update {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"update failed");
        }
        return Result.ok();
    }

    public Result<Void> updateAsync(final String index, final T model, Function<T, ?> function) {
        log.info("updateAsync, {}, model:{}", (Object)index, model);
        if (model == null) {
            log.info("model is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"model is null");
        }
        String id = this.getId(model, function);
        if (id == null) {
            log.warn("id is null, model:{}", model);
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"id is null");
        }
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        Map<String, Object> map = JacksonUtil.toMap(model);
        updateRequest.doc(Maps.filterValues(map, Objects::nonNull), XContentType.JSON);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        updateRequest.retryOnConflict(3);
        try {
            final long time = System.currentTimeMillis();
            this.restHighLevelClient.updateAsync(updateRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<UpdateResponse>(){

                public void onResponse(UpdateResponse indexResponse) {
                    log.info("update success:{}", model);
                    EsWrapper.this.logCostTime(index, "updateAsync", time);
                }

                public void onFailure(Exception e) {
                    log.error("update failed:{}", model, (Object)e);
                    EsWrapper.this.logCostTime(index, "updateAsync", time);
                }
            });
        }
        catch (Exception e) {
            log.error("updateAsync {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"updateAsync failed");
        }
        return Result.ok();
    }

    public Result<Void> upsert(String index, T model, Function<T, ?> function) {
        log.info("upsert, {}, model:{}", (Object)index, model);
        if (model == null) {
            log.info("model is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"model is null");
        }
        String id = this.getId(model, function);
        if (id == null) {
            log.warn("id is null, model:{}", model);
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"id is null");
        }
        UpdateRequest updateRequest = new UpdateRequest(index, id);
        Map<String, Object> map = JacksonUtil.toMap(model);
        updateRequest.doc(Maps.filterValues(map, Objects::nonNull), XContentType.JSON);
        updateRequest.upsert(map, XContentType.JSON);
        updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        updateRequest.retryOnConflict(3);
        try {
            long time = System.currentTimeMillis();
            this.restHighLevelClient.update(updateRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "upsert", time);
        }
        catch (Exception e) {
            log.error("update {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"update failed");
        }
        log.info("upsert success");
        return Result.ok();
    }

    public Result<Void> delete(String index, String id) {
        log.info("delete, {}, id:{}", (Object)index, (Object)id);
        if (id == null) {
            log.warn("id is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"id is null");
        }
        DeleteRequest deleteRequest = new DeleteRequest(index, id);
        try {
            long time = System.currentTimeMillis();
            this.restHighLevelClient.delete(deleteRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "delete", time);
        }
        catch (IOException e) {
            log.error("delete {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"delete failed");
        }
        return Result.ok();
    }

    public Result<Void> delete(String index, T model, Function<T, ?> function) {
        log.info("delete, {}, model:{}", (Object)index, model);
        return this.delete(index, this.getId(model, function));
    }

    public Result<Void> deleteAsync(final String index, final String id) {
        log.info("deleteAsync, {}, id:{}", (Object)index, (Object)id);
        if (id == null) {
            log.warn("id is null");
            return Result.error((int)ResultCode.USER_PARAM_REQUIRED.getCode(), (String)"id is null");
        }
        DeleteRequest deleteRequest = new DeleteRequest(index, id);
        try {
            final long time = System.currentTimeMillis();
            this.restHighLevelClient.deleteAsync(deleteRequest, RequestOptions.DEFAULT, (ActionListener)new ActionListener<DeleteResponse>(){

                public void onResponse(DeleteResponse indexResponse) {
                    log.info("delete success:{}", (Object)id);
                    EsWrapper.this.logCostTime(index, "delete", time);
                }

                public void onFailure(Exception e) {
                    log.error("delete failed:{}", (Object)id, (Object)e);
                    EsWrapper.this.logCostTime(index, "delete", time);
                }
            });
        }
        catch (Exception e) {
            log.error("deleteAsync {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"deleteAsync failed");
        }
        return Result.ok();
    }

    public Result<Void> deleteAsync(String index, T model, Function<T, ?> function) {
        log.info("deleteAsync, {}, model:{}", (Object)index, model);
        return this.deleteAsync(index, this.getId(model, function));
    }

    public Result<Void> batchIndex(String index, Collection<T> list, Function<T, ?> function) {
        BulkResponse bulkResponse;
        log.info("batchInsert {}, size:{}, list:{}", new Object[]{index, CollectionUtils.size(list), list});
        if (CollectionUtils.isEmpty(list)) {
            log.info("list is empty");
            return Result.ok();
        }
        long startTime = System.currentTimeMillis();
        BulkRequest bulkRequest = new BulkRequest();
        for (T model : list) {
            if (model == null) continue;
            String id = this.getId(model, function);
            if (id == null) {
                log.warn("id is null, model:{}", model);
            }
            Map<String, Object> map = JacksonUtil.toMap(model);
            IndexRequest indexRequest = new IndexRequest(index).id(id);
            indexRequest.source(map, XContentType.JSON);
            bulkRequest.add(indexRequest);
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        long buildRequestTime = System.currentTimeMillis();
        try {
            if (log.isDebugEnabled()) {
                log.debug("bulkInsert list:{}", list);
            }
            long time = System.currentTimeMillis();
            bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "bulkInsert", time);
        }
        catch (IOException e) {
            log.error("bulk insert {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"bulk insert failed");
        }
        long bulkEndTime = System.currentTimeMillis();
        log.info("bulk insert response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            if (!StringUtils.isNotBlank((CharSequence)response.getFailureMessage())) continue;
            log.error("bulk insert {} response.id:{}, error:{}", new Object[]{index, response.getId(), response.getFailureMessage()});
        }
        long wasteTime = System.currentTimeMillis() - bulkEndTime;
        long requestTime = bulkEndTime - buildRequestTime;
        long buildTime = buildRequestTime - startTime;
        log.info("batch insert {}, buildTime:{}ms, requestTime:{}ms, wasteTime:{}ms, size={}", new Object[]{index, buildTime, requestTime, wasteTime, CollectionUtils.size(list)});
        return Result.ok();
    }

    public Result<Void> batchUpdate(String index, Collection<T> list, Function<T, ?> function) {
        BulkResponse bulkResponse;
        log.info("batchUpdate {}, size:{}", (Object)index, (Object)CollectionUtils.size(list));
        if (CollectionUtils.isEmpty(list)) {
            log.info("list is empty");
            return Result.ok();
        }
        long startTime = System.currentTimeMillis();
        BulkRequest bulkRequest = new BulkRequest();
        for (T model : list) {
            String id = this.getId(model, function);
            if (StringUtils.isEmpty((CharSequence)id)) {
                log.warn("id is null, model:{}", model);
                continue;
            }
            UpdateRequest updateRequest = new UpdateRequest(index, id);
            Map<String, Object> map = JacksonUtil.toMap(model);
            updateRequest.doc(Maps.filterValues(map, Objects::nonNull), XContentType.JSON);
            updateRequest.retryOnConflict(3);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        long buildRequestTime = System.currentTimeMillis();
        try {
            if (log.isDebugEnabled()) {
                log.debug("bulkUpdate list:{}", list);
            }
            long time = System.currentTimeMillis();
            bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "bulkUpdate", time);
        }
        catch (IOException e) {
            log.error("bulk update {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"bulk update failed");
        }
        long bulkEndTime = System.currentTimeMillis();
        log.info("bulk update response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            if (!StringUtils.isNotBlank((CharSequence)response.getFailureMessage())) continue;
            log.error("bulk update {} response.id:{}, error:{}", new Object[]{index, response.getId(), response.getFailureMessage()});
        }
        long wasteTime = System.currentTimeMillis() - bulkEndTime;
        long requestTime = bulkEndTime - buildRequestTime;
        long buildTime = buildRequestTime - startTime;
        log.info("batch update {}, buildTime:{}ms, requestTime:{}ms, wasteTime:{}ms, size={}", new Object[]{index, buildTime, requestTime, wasteTime, CollectionUtils.size(list)});
        return Result.ok();
    }

    public Result<Void> batchUpsert(String index, Collection<T> list, Function<T, ?> function, boolean ignoreNull) {
        BulkResponse bulkResponse;
        log.info("batchUpsert {}, size:{}, ignoreNull:{}", new Object[]{index, CollectionUtils.size(list), ignoreNull});
        if (CollectionUtils.isEmpty(list)) {
            log.info("list is empty");
            return Result.ok();
        }
        long startTime = System.currentTimeMillis();
        BulkRequest bulkRequest = new BulkRequest();
        for (T model : list) {
            String id = this.getId(model, function);
            if (StringUtils.isEmpty((CharSequence)id)) {
                log.warn("id is null, model:{}", model);
                continue;
            }
            UpdateRequest updateRequest = new UpdateRequest(index, id);
            Map map = JacksonUtil.toMap(model);
            if (ignoreNull) {
                map = Maps.filterValues(map, Objects::nonNull);
            }
            updateRequest.doc(map, XContentType.JSON);
            updateRequest.upsert(map, XContentType.JSON);
            updateRequest.retryOnConflict(3);
            bulkRequest.add(updateRequest);
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        long buildRequestTime = System.currentTimeMillis();
        try {
            if (log.isDebugEnabled()) {
                log.debug("bulkUpsert list:{}", (Object)list.size());
            }
            long time = System.currentTimeMillis();
            bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "batchUpsert", time);
        }
        catch (IOException e) {
            log.error("bulk update {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"bulk update failed");
        }
        long bulkEndTime = System.currentTimeMillis();
        log.info("bulk update response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            if (!StringUtils.isNotBlank((CharSequence)response.getFailureMessage())) continue;
            log.error("bulk update {} response.id:{}, error:{}", new Object[]{index, response.getId(), response.getFailureMessage()});
        }
        long wasteTime = System.currentTimeMillis() - bulkEndTime;
        long requestTime = bulkEndTime - buildRequestTime;
        long buildTime = buildRequestTime - startTime;
        log.info("batch update {}, buildTime:{}ms, requestTime:{}ms, wasteTime:{}ms, size={}", new Object[]{index, buildTime, requestTime, wasteTime, CollectionUtils.size(list)});
        return Result.ok();
    }

    public Result<Void> batchDelete(String index, Collection<T> list, Function<T, ?> function) {
        BulkResponse bulkResponse;
        log.info("batchDelete {}, size={}", (Object)index, (Object)CollectionUtils.size(list));
        if (CollectionUtils.isEmpty(list)) {
            log.info("list is empty");
            return Result.ok();
        }
        long startTime = System.currentTimeMillis();
        BulkRequest bulkRequest = new BulkRequest();
        for (T model : list) {
            if (model == null) continue;
            String id = this.getId(model, function);
            if (id == null) {
                log.warn("id is null, model:{}", model);
            }
            bulkRequest.add(new DeleteRequest(index, id));
        }
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        long buildRequestTime = System.currentTimeMillis();
        try {
            if (log.isDebugEnabled()) {
                log.debug("bulkDelete list:{}", list);
            }
            long time = System.currentTimeMillis();
            bulkResponse = this.restHighLevelClient.bulk(bulkRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "bulkDelete", time);
        }
        catch (IOException e) {
            log.error("bulk update {} failed", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"bulk update failed");
        }
        long bulkEndTime = System.currentTimeMillis();
        log.info("bulk update response:{}", (Object)bulkResponse.status());
        for (BulkItemResponse response : bulkResponse) {
            if (!StringUtils.isNotBlank((CharSequence)response.getFailureMessage())) continue;
            log.error("bulk update {} response.id:{}, error:{}", new Object[]{index, response.getId(), response.getFailureMessage()});
        }
        long wasteTime = System.currentTimeMillis() - bulkEndTime;
        long requestTime = bulkEndTime - buildRequestTime;
        long buildTime = buildRequestTime - startTime;
        log.info("batch update {}, buildTime:{}ms, requestTime:{}ms, wasteTime:{}ms, size={}", new Object[]{index, buildTime, requestTime, wasteTime, CollectionUtils.size(list)});
        return Result.ok();
    }

    public Result<List<T>> selectList(String index, QueryBuilder query, PageDto pageDto, Class<T> clazz) {
        return this.selectList(index, query, Collections.emptyList(), pageDto, null, null, clazz);
    }

    public Result<List<T>> selectList(String index, QueryBuilder query, SortBuilder<?> sort, PageDto pageDto, Class<T> clazz) {
        return this.selectList(index, query, Collections.singletonList(sort), pageDto, null, null, clazz);
    }

    public Result<List<T>> selectList(String index, QueryBuilder query, List<SortBuilder<?>> sorts, PageDto pageDto, Class<T> clazz) {
        return this.selectList(index, query, sorts, pageDto, null, null, clazz);
    }

    public Result<List<T>> selectList(String index, QueryBuilder query, List<SortBuilder<?>> sorts, PageDto pageDto, String[] includeFields, String[] excludeFields, Class<T> clazz) {
        SearchResponse searchResponse;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.query(query);
        if (CollectionUtils.isNotEmpty(sorts)) {
            for (SortBuilder<?> sort : sorts) {
                if (sort == null) continue;
                searchSourceBuilder.sort(sort);
            }
        }
        if (includeFields != null || excludeFields != null) {
            searchSourceBuilder.fetchSource(includeFields, excludeFields);
        }
        if (pageDto != null) {
            searchSourceBuilder.size(pageDto.getPageSize().intValue());
            searchSourceBuilder.from(pageDto.getOffset());
        } else {
            searchSourceBuilder.size(10000);
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(searchSourceBuilder);
        log.info("query es param:{}", (Object)searchRequest.source().toString());
        try {
            long time = System.currentTimeMillis();
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "selectList", time);
        }
        catch (Exception e) {
            log.error("query failed, index:{}", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        if (searchResponse == null || searchResponse.getHits() == null || searchResponse.getHits().getTotalHits() == null) {
            log.warn("searchResponse is null");
            if (pageDto != null) {
                pageDto.setCount(Integer.valueOf(0));
            }
            return Result.ok(Collections.emptyList(), (PageDto)pageDto);
        }
        int total = (int)searchResponse.getHits().getTotalHits().value;
        if (pageDto != null) {
            pageDto.setCount(Integer.valueOf(total));
        }
        if (total == 0) {
            log.info("query result is empty");
            return Result.ok(Collections.emptyList(), (PageDto)pageDto);
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)total);
        for (SearchHit hit : searchResponse.getHits()) {
            String json = hit.getSourceAsString();
            try {
                T model = JacksonUtil.str2Obj(json, clazz);
                list.add(model);
            }
            catch (Exception e) {
                log.error("parse failed, sourceAsString:{}", (Object)json, (Object)e);
            }
        }
        return Result.ok((Object)list, (PageDto)pageDto);
    }

    public Result<Long> selectCount(String index, QueryBuilder queryBuilder) {
        SearchResponse searchResponse;
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.query(queryBuilder);
        searchSourceBuilder.trackTotalHits(true);
        searchSourceBuilder.size(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{index});
        searchRequest.source(searchSourceBuilder);
        log.info("query es param:{}", (Object)searchRequest.source().toString());
        try {
            long time = System.currentTimeMillis();
            searchResponse = this.restHighLevelClient.search(searchRequest, RequestOptions.DEFAULT);
            this.logCostTime(index, "selectCount", time);
        }
        catch (Exception e) {
            log.error("query failed, index:{}", (Object)index, (Object)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"\u67e5\u8be2\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
        }
        if (searchResponse == null || searchResponse.getHits() == null || searchResponse.getHits().getTotalHits() == null) {
            log.warn("searchResponse is null");
            return Result.ok((Object)0L);
        }
        return Result.ok((Object)searchResponse.getHits().getTotalHits().value);
    }

    public Result<Void> updateByQuery(UpdateByQueryRequest request) {
        log.info("updateByQuery request:{}", (Object)request);
        request.setRefresh(true);
        request.setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        try {
            long time = System.currentTimeMillis();
            BulkByScrollResponse response = this.restHighLevelClient.updateByQuery(request, RequestOptions.DEFAULT);
            log.info("updateByQuery response:{}", (Object)response);
            this.logCostTime(request.getSearchRequest().indices()[0], "updateByQuery", time);
        }
        catch (Exception e) {
            log.error("updateByQuery failed", (Throwable)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"updateByQuery failed");
        }
        return Result.ok();
    }

    public Result<Void> updateByQueryAsync(final UpdateByQueryRequest request) {
        log.info("updateByQuery request:{}", (Object)request);
        request.setRefresh(true);
        request.setIndicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
        try {
            final long time = System.currentTimeMillis();
            final String traceId = TraceIdUtils.getTraceId();
            this.restHighLevelClient.updateByQueryAsync(request, RequestOptions.DEFAULT, (ActionListener)new ActionListener<BulkByScrollResponse>(){

                public void onResponse(BulkByScrollResponse response) {
                    TraceIdUtils.setTraceId(traceId);
                    log.info("updateByQuery response:{}", (Object)response);
                    EsWrapper.this.logCostTime(request.getSearchRequest().indices()[0], "updateByQueryAsync", time);
                }

                public void onFailure(Exception e) {
                    TraceIdUtils.setTraceId(traceId);
                    log.error("updateByQuery failed", (Throwable)e);
                    EsWrapper.this.logCostTime(request.getSearchRequest().indices()[0], "updateByQueryAsync", time);
                }
            });
        }
        catch (Exception e) {
            log.error("updateByQuery failed", (Throwable)e);
            return Result.error((int)ResultCode.SYSTEM_ERROR.getCode(), (String)"updateByQuery failed");
        }
        return Result.ok();
    }

    private void logCostTime(String index, String function, long startTime) {
        long costTime = System.currentTimeMillis() - startTime;
        log.info("index:{}, function:{}, cost time: {} ms", new Object[]{index, function, costTime});
    }
}

