/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config.xxljob;

import com.baijiayun.duanxunbao.common.config.xxljob.XxlJobProperties;
import com.xxl.job.core.executor.impl.XxlJobSpringExecutor;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={XxlJobProperties.class})
@ConditionalOnProperty(value={"xxljob.enabled"}, havingValue="true", matchIfMissing=true)
public class XxlJobConfiguration {
    private static final Logger log = LoggerFactory.getLogger(XxlJobConfiguration.class);
    @Autowired
    private XxlJobProperties xxlJobProperties;

    @Bean
    public XxlJobSpringExecutor xxlJobExecutor() {
        log.info("xxl-job-executor init");
        XxlJobSpringExecutor xxlJobSpringExecutor = new XxlJobSpringExecutor();
        xxlJobSpringExecutor.setAdminAddresses(this.xxlJobProperties.getAdminAddresses());
        xxlJobSpringExecutor.setAppname(this.xxlJobProperties.getAppname());
        if (StringUtils.isNotBlank((CharSequence)this.xxlJobProperties.getIp())) {
            xxlJobSpringExecutor.setIp(this.xxlJobProperties.getIp());
        }
        if (this.xxlJobProperties.getPort() > 0) {
            xxlJobSpringExecutor.setPort(this.xxlJobProperties.getPort());
        }
        xxlJobSpringExecutor.setAccessToken(this.xxlJobProperties.getAccessToken());
        xxlJobSpringExecutor.setLogPath(this.xxlJobProperties.getLogPath());
        xxlJobSpringExecutor.setLogRetentionDays(this.xxlJobProperties.getLogRetentionDays());
        return xxlJobSpringExecutor;
    }
}

