/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config;

import com.baijiayun.duanxunbao.common.config.SignAuthProperties;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.RequestMappingInfoHandlerMapping;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.ParameterBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.ModelRef;
import springfox.documentation.schema.ModelReference;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.ApiKey;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.Contact;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.spring.web.plugins.WebMvcRequestHandlerProvider;
import springfox.documentation.swagger2.annotations.EnableSwagger2WebMvc;

@Configuration
@EnableSwagger2WebMvc
@Profile(value={"dev", "test", "test2"})
@ConditionalOnProperty(prefix="swagger", name={"enable"}, havingValue="true")
public class Swagger2Config
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(Swagger2Config.class);
    @Autowired
    private SignAuthProperties signAuthProperties;
    @Value(value="${interceptor.sign.enable:false}")
    private Boolean sign;
    @Value(value="${interceptor.auth.enable:false}")
    private Boolean auth;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
        registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
    }

    @Bean(value={"defaultApi2"})
    public Docket defaultApi2() {
        log.info("init swagger");
        Docket docket = new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).select().apis(RequestHandlerSelectors.basePackage((String)"com.baijiayun.duanxunbao")).apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
        if (this.auth.booleanValue()) {
            docket.securitySchemes(Collections.singletonList(this.securityScheme())).securityContexts(this.securityContexts()).globalOperationParameters(this.setHeaders());
        }
        return docket;
    }

    SecurityScheme securityScheme() {
        return new ApiKey("B-Token", "B-Token", "header");
    }

    private List<Parameter> setHeaders() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        pars.add(new ParameterBuilder().name("B-Token").description("token").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
        if (this.sign.booleanValue()) {
            pars.add(new ParameterBuilder().name("B-Timestamp").description("\u65f6\u95f4\u6233").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
            pars.add(new ParameterBuilder().name("B-Sign").description("\u53c2\u6570\u7b7e\u540d").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
            pars.add(new ParameterBuilder().name("B-Request-ID").description("\u8bf7\u6c42ID").modelRef((ModelReference)new ModelRef("string")).parameterType("header").required(false).build());
        }
        return pars;
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("\u77ed\u8baf\u5b9d\u540e\u7aef\u63a5\u53e3\u6587\u6863").version("1.0").description("\u540e\u53f0API\u63a5\u53e3").contact(new Contact("\u767e\u5bb6\u4e91", "www.baijiayun.com", "leads@baijiayun.com")).license("The Apache License, Version 2.0").licenseUrl("http://www.apache.org/licenses/LICENSE-2.0.html").build();
    }

    private List<SecurityContext> securityContexts() {
        return Collections.singletonList(SecurityContext.builder().securityReferences(this.defaultAuth()).forPaths(PathSelectors.regex((String)"^(?!auth).*$")).build());
    }

    private List<SecurityReference> defaultAuth() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        return new ArrayList<SecurityReference>(Collections.singleton(new SecurityReference("B-Token", authorizationScopes)));
    }

    @Bean
    public BeanPostProcessor springfoxHandlerProviderBeanPostProcessor() {
        return new BeanPostProcessor(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof WebMvcRequestHandlerProvider) {
                    this.customizeSpringfoxHandlerMappings(this.getHandlerMappings(bean));
                }
                return bean;
            }

            private <T extends RequestMappingInfoHandlerMapping> void customizeSpringfoxHandlerMappings(List<T> mappings) {
                List copy = mappings.stream().filter(mapping -> mapping.getPatternParser() == null).collect(Collectors.toList());
                mappings.clear();
                mappings.addAll(copy);
            }

            private List<RequestMappingInfoHandlerMapping> getHandlerMappings(Object bean) {
                try {
                    Field field = ReflectionUtils.findField(bean.getClass(), (String)"handlerMappings");
                    field.setAccessible(true);
                    return (List)field.get(bean);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }
}

