/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config;

import com.baijiayun.duanxunbao.common.oss.AliyunOss;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="aliyun.oss", name={"endpoint"})
public class OssConfig {
    private static final Logger log = LoggerFactory.getLogger(OssConfig.class);
    @Value(value="${aliyun.oss.endpoint}")
    private String endpoint;
    @Value(value="${aliyun.oss.accessKeyId}")
    private String accessKeyId;
    @Value(value="${aliyun.oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${aliyun.oss.roleArn}")
    private String roleArn;
    @Value(value="${aliyun.oss.bucket}")
    private String bucket;
    @Value(value="${aliyun.oss.file.expireDays}")
    private long expireDays;

    @Bean
    public AliyunOss getAliyunOss() {
        log.info("aliyun oss init");
        return new AliyunOss(this.endpoint, this.accessKeyId, this.accessKeySecret, this.roleArn, this.bucket, this.expireDays);
    }
}

