/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config;

import com.baijiayun.duanxunbao.common.kafka.trace.ProducerRequestIdInterceptor;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
@ConditionalOnProperty(name={"spring.kafka.bootstrap-servers"})
public class KafkaConfig {
    @Value(value="${spring.kafka.bootstrap-servers}")
    String servers;
    @Value(value="${spring.kafka.producer.acks}")
    String acks;
    @Value(value="${spring.kafka.producer.retries}")
    int retries;
    @Value(value="${spring.kafka.producer.batch-size}")
    int batchSize;
    @Value(value="${spring.kafka.producer.key-serializer}")
    String keySerializer;
    @Value(value="${spring.kafka.producer.value-serializer}")
    String valueSerializer;

    private Map<String, Object> getKafkaConf() {
        HashMap map = Maps.newHashMap();
        map.put("bootstrap.servers", this.servers);
        map.put("acks", this.acks);
        map.put("retries", this.retries);
        map.put("batch.size", this.batchSize);
        map.put("key.serializer", this.keySerializer);
        map.put("value.serializer", this.valueSerializer);
        map.put("interceptor.classes", ProducerRequestIdInterceptor.class.getName());
        return map;
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        DefaultKafkaProducerFactory producerFactory = new DefaultKafkaProducerFactory(this.getKafkaConf());
        return new KafkaTemplate((ProducerFactory)producerFactory);
    }
}

