/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="elasticsearch", name={"ip"})
public class ElasticSearchConfig {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchConfig.class);
    @Value(value="${elasticsearch.scheme:http}")
    private String scheme;
    @Value(value="${elasticsearch.ip:}")
    private String ip;
    @Value(value="${elasticsearch.port:9200}")
    private int port = 9200;
    @Value(value="${elasticsearch.username:}")
    private String username;
    @Value(value="${elasticsearch.password:}")
    private String password;
    @Value(value="${elasticsearch.httpclient.max-connections:30}")
    private Integer maxConn;
    @Value(value="${elasticsearch.httpclient.max-conn-per-route:10}")
    private Integer maxConnPerRoute;

    @Bean
    public RestHighLevelClient elasticsearchClient() {
        log.info("Elastic Search RestHighLevelClient init");
        String[] hostArray = this.ip.split(",");
        HttpHost[] httpHosts = (HttpHost[])Arrays.stream(hostArray).map(host -> new HttpHost(host, this.port, this.scheme)).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])httpHosts).setHttpClientConfigCallback(httpClientBuilder -> {
            httpClientBuilder.setMaxConnTotal(this.maxConn.intValue());
            httpClientBuilder.setMaxConnPerRoute(this.maxConnPerRoute.intValue());
            return httpClientBuilder;
        });
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.username, this.password})) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.username, this.password));
            builder.setHttpClientConfigCallback(arg_0 -> ElasticSearchConfig.lambda$elasticsearchClient$3((CredentialsProvider)credentialsProvider, arg_0));
        }
        return new RestHighLevelClient(builder);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$elasticsearchClient$3(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpAsyncClientBuilder) {
        return httpAsyncClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

