/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.common.config;

import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="duanxunbao.domain")
public class DomainProperties {
    private String protocol;
    private String root;
    private String app;
    private String manager;
    private String admin;
    private String www;
    private String pay;
    private String weixinAuth;

    public String getAppAddress() {
        if (StringUtils.isNotBlank((CharSequence)this.app)) {
            return this.protocol + this.app;
        }
        return this.protocol + this.root;
    }

    public String getManagerAddress() {
        return this.protocol + this.manager;
    }

    public String getRootAddress() {
        return this.protocol + this.root;
    }

    public String getWeixinAuthAddress() {
        if (StringUtils.isNotBlank((CharSequence)this.weixinAuth)) {
            return this.protocol + this.weixinAuth;
        }
        return this.protocol + this.root;
    }

    public boolean isInternalDomain(String domain) {
        if (domain.startsWith("192.168.") || domain.startsWith("10.") || domain.startsWith("172.16.")) {
            return true;
        }
        return StringUtils.equals((CharSequence)domain, (CharSequence)"localhost") || StringUtils.equals((CharSequence)domain, (CharSequence)"127.0.0.1");
    }

    public boolean isReservedDomain(String domain) {
        return domain.equals(this.root) || domain.equals(this.manager) || domain.equals(this.admin) || domain.equals(this.www) || domain.equals(this.pay) || domain.equals(this.weixinAuth);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getRoot() {
        return this.root;
    }

    public String getApp() {
        return this.app;
    }

    public String getManager() {
        return this.manager;
    }

    public String getAdmin() {
        return this.admin;
    }

    public String getWww() {
        return this.www;
    }

    public String getPay() {
        return this.pay;
    }

    public String getWeixinAuth() {
        return this.weixinAuth;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setRoot(String root) {
        this.root = root;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public void setAdmin(String admin) {
        this.admin = admin;
    }

    public void setWww(String www) {
        this.www = www;
    }

    public void setPay(String pay) {
        this.pay = pay;
    }

    public void setWeixinAuth(String weixinAuth) {
        this.weixinAuth = weixinAuth;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DomainProperties)) {
            return false;
        }
        DomainProperties other = (DomainProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        String this$root = this.getRoot();
        String other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$manager = this.getManager();
        String other$manager = other.getManager();
        if (this$manager == null ? other$manager != null : !this$manager.equals(other$manager)) {
            return false;
        }
        String this$admin = this.getAdmin();
        String other$admin = other.getAdmin();
        if (this$admin == null ? other$admin != null : !this$admin.equals(other$admin)) {
            return false;
        }
        String this$www = this.getWww();
        String other$www = other.getWww();
        if (this$www == null ? other$www != null : !this$www.equals(other$www)) {
            return false;
        }
        String this$pay = this.getPay();
        String other$pay = other.getPay();
        if (this$pay == null ? other$pay != null : !this$pay.equals(other$pay)) {
            return false;
        }
        String this$weixinAuth = this.getWeixinAuth();
        String other$weixinAuth = other.getWeixinAuth();
        return !(this$weixinAuth == null ? other$weixinAuth != null : !this$weixinAuth.equals(other$weixinAuth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DomainProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        String $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $manager = this.getManager();
        result = result * 59 + ($manager == null ? 43 : $manager.hashCode());
        String $admin = this.getAdmin();
        result = result * 59 + ($admin == null ? 43 : $admin.hashCode());
        String $www = this.getWww();
        result = result * 59 + ($www == null ? 43 : $www.hashCode());
        String $pay = this.getPay();
        result = result * 59 + ($pay == null ? 43 : $pay.hashCode());
        String $weixinAuth = this.getWeixinAuth();
        result = result * 59 + ($weixinAuth == null ? 43 : $weixinAuth.hashCode());
        return result;
    }

    public String toString() {
        return "DomainProperties(protocol=" + this.getProtocol() + ", root=" + this.getRoot() + ", app=" + this.getApp() + ", manager=" + this.getManager() + ", admin=" + this.getAdmin() + ", www=" + this.getWww() + ", pay=" + this.getPay() + ", weixinAuth=" + this.getWeixinAuth() + ")";
    }
}

