/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk.utils;

import com.baijiayun.openapi.sdk.base.BjyPartnerInfo;
import com.baijiayun.openapi.sdk.base.BjyResult;
import com.baijiayun.openapi.sdk.base.Request;
import com.baijiayun.openapi.sdk.utils.IgnoreFileSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjyServiceUtil {
    private static final Logger log = LoggerFactory.getLogger(BjyServiceUtil.class);
    private static final String SIGN_SPLIT = "&";
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private BjyServiceUtil() {
    }

    public static String createSignData(Map<String, String> params) {
        StringBuilder signData = new StringBuilder();
        if (params != null && !params.isEmpty()) {
            int size = params.size();
            String[] paraNames = new String[size];
            Arrays.sort(params.keySet().toArray(paraNames), (o1, o2) -> {
                int result = o1.compareTo((String)o2);
                if (result == 0) {
                    return 0;
                }
                if (o1.equals("partner_key")) {
                    result = 1;
                }
                if (o2.equals("partner_key")) {
                    result = -1;
                }
                return result;
            });
            for (int i = 0; i < size; ++i) {
                String paraName = paraNames[i];
                String value = params.get(paraName);
                if (i != 0) {
                    signData.append(SIGN_SPLIT);
                }
                signData.append(paraName).append("=").append(value);
            }
        }
        return signData.toString();
    }

    public static String getSignature(String signData) {
        return DigestUtils.md5Hex((String)signData);
    }

    public static String getUrl(String privateDomain, String uri) {
        if (StringUtils.isBlank((CharSequence)privateDomain)) {
            return uri;
        }
        if (StringUtils.isBlank((CharSequence)uri)) {
            return privateDomain;
        }
        if (!privateDomain.endsWith("/") && !uri.trim().startsWith("/")) {
            privateDomain = privateDomain + "/";
        } else if (privateDomain.endsWith("/") && uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        return privateDomain + uri;
    }

    public static void sign(Map<String, String> paramMap, BjyPartnerInfo partnerInfo) {
        paramMap.put("partner_id", partnerInfo.getPartnerId());
        paramMap.put("timestamp", String.valueOf(System.currentTimeMillis()));
        ArrayList list = new ArrayList();
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(paramMap);
        sortedMap.forEach((key, values) -> {
            if (StringUtils.isEmpty((CharSequence)values)) {
                list.add(key + "=");
            } else {
                list.add(key + "=" + values);
            }
        });
        String signData = StringUtils.join(list, (String)SIGN_SPLIT) + "&partner_key=" + partnerInfo.getPartnerKey();
        String sign = DigestUtils.md5Hex((String)signData);
        paramMap.put("sign", sign);
    }

    public static <T> BjyResult<T> get(BjyPartnerInfo base, String uri, Object params, Class<T> dataType) throws IOException {
        String resultJson = BjyServiceUtil.invoke(Request.Method.GET, base, uri, params);
        try {
            return BjyServiceUtil.str2BjcloudResult(resultJson, dataType);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790json\u5931\u8d25", e);
        }
    }

    public static <T> BjyResult<T> get(BjyPartnerInfo base, String uri, Object params, TypeReference<BjyResult<T>> typeReference) throws IOException {
        String resultJson = BjyServiceUtil.invoke(Request.Method.GET, base, uri, params);
        try {
            return BjyServiceUtil.str2Obj(resultJson, typeReference);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790json\u5931\u8d25", e);
        }
    }

    public static BjyResult<Void> post(BjyPartnerInfo base, String uri, Object params) throws IOException {
        return BjyServiceUtil.post(base, uri, params, Void.class);
    }

    public static <T> BjyResult<T> post(BjyPartnerInfo base, String uri, Object params, Class<T> dataType) throws IOException {
        String resultJson = BjyServiceUtil.invoke(Request.Method.POST, base, uri, params);
        try {
            return BjyServiceUtil.str2BjcloudResult(resultJson, dataType);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790json\u5931\u8d25", e);
        }
    }

    public static <T> T post(BjyPartnerInfo base, String uri, Object params, TypeReference<T> typeReference) throws IOException {
        String resultJson = BjyServiceUtil.invoke(Request.Method.POST, base, uri, params);
        try {
            return BjyServiceUtil.str2Obj(resultJson, typeReference);
        }
        catch (IOException e) {
            log.error("\u89e3\u6790json\u5931\u8d25", (Throwable)e);
            throw new IllegalArgumentException("\u89e3\u6790json\u5931\u8d25", e);
        }
    }

    public static CloseableHttpClient getHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(35000).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(config).build();
    }

    public static String invoke(Request.Method method, BjyPartnerInfo base, String uri, Object params) throws IOException {
        Map<String, File> fileMap;
        String url = BjyServiceUtil.getUrl(base.getPrivateDomain(), uri);
        Map<String, String> paramMap = BjyServiceUtil.beanToMap(params);
        BjyServiceUtil.sign(paramMap, base);
        String resultJson = method == Request.Method.GET ? BjyServiceUtil.doGet(url, paramMap, null) : ((fileMap = BjyServiceUtil.beanToFileMap(params)).isEmpty() ? BjyServiceUtil.doPost(url, paramMap, null, null) : BjyServiceUtil.doPost(url, paramMap, fileMap, null));
        log.info("resultJson\uff1d{}", (Object)resultJson);
        return resultJson;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGet(String url, Map<String, String> params, Map<String, String> headers) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = BjyServiceUtil.getHttpClient();){
            if (params != null && !params.isEmpty()) {
                url = url + "?" + EntityUtils.toString((HttpEntity)BjyServiceUtil.getUrlEncodedFormEntity(params));
            }
            HttpGet httpGet = new HttpGet(url);
            BjyServiceUtil.setHeaders((HttpRequestBase)httpGet, headers);
            String string = BjyServiceUtil.execute(httpClient, (HttpUriRequest)httpGet);
            return string;
        }
        catch (IOException e) {
            log.error("doGet exception - ", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPost(String url, Map<String, String> params, Map<String, File> files, Map<String, String> headers) throws IOException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)url), (Object)"url is blank");
        try (CloseableHttpClient httpClient = BjyServiceUtil.getHttpClient();){
            HttpPost post = new HttpPost(url);
            if (files == null || files.isEmpty()) {
                post.setEntity(BjyServiceUtil.getUrlEncodedFormEntity(params));
            } else {
                post.setEntity(BjyServiceUtil.getMultipartFormEntity(params, files));
            }
            BjyServiceUtil.setHeaders((HttpRequestBase)post, headers);
            String string = BjyServiceUtil.execute(httpClient, (HttpUriRequest)post);
            return string;
        }
        catch (IOException e) {
            log.error("doPost exception - ", (Throwable)e);
            throw e;
        }
    }

    private static HttpEntity getUrlEncodedFormEntity(Map<String, String> params) {
        ArrayList pairs = Lists.newArrayListWithCapacity((int)params.size());
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String value = entry.getValue();
            if (value == null) continue;
            pairs.add(new BasicNameValuePair(entry.getKey(), value));
        }
        return new UrlEncodedFormEntity((Iterable)pairs, StandardCharsets.UTF_8);
    }

    private static HttpEntity getMultipartFormEntity(Map<String, String> params, Map<String, File> files) {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.RFC6532);
        if (params != null && !params.isEmpty()) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                builder.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue(), ContentType.TEXT_PLAIN.withCharset(StandardCharsets.UTF_8)));
            }
        }
        if (files != null && !files.isEmpty()) {
            for (Map.Entry<String, Object> entry : files.entrySet()) {
                File file = (File)entry.getValue();
                builder.addPart(entry.getKey(), (ContentBody)new FileBody(file, ContentType.DEFAULT_BINARY, new String(file.getName().getBytes(StandardCharsets.UTF_8))));
            }
        }
        return builder.build();
    }

    private static void setHeaders(HttpRequestBase req, Map<String, String> headers) {
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((HttpRequestBase)req).setHeader(arg_0, arg_1));
        }
    }

    private static String execute(CloseableHttpClient client, HttpUriRequest request) throws IOException {
        CloseableHttpResponse response = client.execute(request);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            request.abort();
            throw new IllegalStateException("HttpClient,error status code :" + statusCode);
        }
        HttpEntity entity = response.getEntity();
        String result = null;
        if (entity != null) {
            result = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return result;
    }

    public static Map<String, String> beanToMap(Object bean) throws IOException {
        HashMap params = Maps.newHashMap();
        Map paramMap = (Map)MAPPER.convertValue(bean, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        if (MapUtils.isNotEmpty((Map)paramMap)) {
            for (Map.Entry entry : paramMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (null == value) continue;
                if (value instanceof File || value instanceof InputStream || value instanceof OutputStream) {
                    log.info("ignore file field: {}", (Object)key);
                    continue;
                }
                if (value instanceof String) {
                    params.put(key, (String)value);
                    continue;
                }
                if (value instanceof Number || value instanceof Boolean || value instanceof Enum || value instanceof Character || value instanceof CharSequence) {
                    params.put(key, String.valueOf(value));
                    continue;
                }
                params.put(key, MAPPER.writeValueAsString(value));
            }
        }
        return params;
    }

    public static Map<String, File> beanToFileMap(Object obj) {
        Field[] fields;
        HashMap params = Maps.newHashMap();
        if (obj instanceof Map) {
            Map paramMap = (Map)obj;
            if (MapUtils.isNotEmpty((Map)paramMap)) {
                for (Map.Entry entry : paramMap.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    if (null == value || !(value instanceof File)) continue;
                    params.put(key, (File)value);
                }
            }
            return params;
        }
        if (obj instanceof Iterable || obj instanceof Enum || obj instanceof Number || obj instanceof Boolean || obj instanceof Character || obj instanceof CharSequence) {
            return params;
        }
        Class<?> clazz = obj.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getType().equals(File.class)) continue;
            field.setAccessible(true);
            try {
                File file = (File)field.get(obj);
                if (file == null) continue;
                String fieldName = field.getName();
                JsonProperty jsonProperty = field.getAnnotation(JsonProperty.class);
                if (jsonProperty != null) {
                    fieldName = jsonProperty.value();
                }
                params.put(fieldName, file);
            }
            catch (IllegalAccessException e) {
                log.error("get file field error: {}", (Object)field, (Object)e);
            }
        }
        return params;
    }

    public static <T> T str2Obj(String s, TypeReference<T> valueType) throws IOException {
        return (T)MAPPER.readValue(s, valueType);
    }

    public static <T> T str2Obj(String s, Class<T> valueType) throws IOException {
        return (T)MAPPER.readValue(s, valueType);
    }

    public static <T> T str2Obj(String s, JavaType valueType) throws IOException {
        return (T)MAPPER.readValue(s, valueType);
    }

    public static JavaType constructType(Type type) {
        return MAPPER.getTypeFactory().constructType(type);
    }

    public static <T> BjyResult<T> str2BjcloudResult(String json, Class<T> valueType) throws IOException {
        JavaType javaType = MAPPER.getTypeFactory().constructParametricType(BjyResult.class, new Class[]{valueType});
        return (BjyResult)MAPPER.readValue(json, javaType);
    }

    static {
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        SimpleModule module = new SimpleModule();
        module.addSerializer(File.class, (JsonSerializer)new IgnoreFileSerializer());
        MAPPER.registerModule((Module)module);
    }
}

