/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.BjyClientFactory;
import com.baijiayun.openapi.sdk.base.BjyClient;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import lombok.NonNull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class BjyClientPostProcessor
implements BeanFactoryPostProcessor,
EnvironmentAware {
    private String clientPackage;

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (beanFactory == null) {
            throw new NullPointerException("beanFactory is marked non-null but is null");
        }
        BjyClientFactory factory = new BjyClientFactory();
        Set<Class<?>> clientClazz = this.scanClients();
        for (Class<?> clazz : clientClazz) {
            beanFactory.registerSingleton(clazz.getName(), factory.create(clazz));
        }
    }

    public Set<Class<?>> scanClients() {
        HashSet classes = new HashSet();
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        Resource[] resources = new Resource[]{};
        try {
            String pattern = "classpath*:" + this.clientPackage.replaceAll("\\.", "/") + "/**/*.class";
            resources = resourcePatternResolver.getResources(pattern);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (Resource resource : resources) {
            try {
                MetadataReader reader = metadataReaderFactory.getMetadataReader(resource);
                if (!reader.getAnnotationMetadata().hasAnnotation(BjyClient.class.getName())) continue;
                Class cls = ClassUtils.forName((String)reader.getClassMetadata().getClassName(), (ClassLoader)this.getClass().getClassLoader());
                classes.add(cls);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return classes;
    }

    public void setEnvironment(@NonNull Environment environment) {
        if (environment == null) {
            throw new NullPointerException("environment is marked non-null but is null");
        }
    }

    public void setClientPackage(String clientPackage) {
        this.clientPackage = clientPackage;
    }
}

