/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.BjyCallContext;
import com.baijiayun.openapi.sdk.base.BjyPartnerInfo;
import com.baijiayun.openapi.sdk.base.BjyResult;
import com.baijiayun.openapi.sdk.base.Request;
import com.baijiayun.openapi.sdk.utils.BjyServiceUtil;
import com.fasterxml.jackson.databind.JavaType;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjyClientInvocationHandler
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(BjyClientInvocationHandler.class);

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        log.debug("Invoke {}#{}", (Object)method.getDeclaringClass().getCanonicalName(), (Object)method.getName());
        BjyCallContext context = BjyCallContext.from(method, args);
        BjyPartnerInfo base = context.getBaseReqDto();
        String url = BjyServiceUtil.getUrl(base.getPrivateDomain(), context.getPath());
        Map<String, String> paramMap = BjyServiceUtil.beanToMap(context.getParams());
        BjyServiceUtil.sign(paramMap, base);
        String resultJson = null;
        try {
            log.info("{} ---> {}:{}", new Object[]{base.getPrivateDomain(), context.getMethod(), context.getPath()});
            if (log.isDebugEnabled()) {
                log.debug("request data:{}", paramMap);
            }
            long start = System.currentTimeMillis();
            if (context.getMethod() == Request.Method.GET) {
                resultJson = BjyServiceUtil.doGet(url, paramMap, null);
            } else if (context.getMethod() == Request.Method.POST) {
                Map<String, File> fileMap = BjyServiceUtil.beanToFileMap(context.getParams());
                resultJson = fileMap.isEmpty() ? BjyServiceUtil.doPost(url, paramMap, null, null) : BjyServiceUtil.doPost(url, paramMap, fileMap, null);
            }
            long cost = System.currentTimeMillis() - start;
            if (log.isDebugEnabled()) {
                log.debug("Result {}", (Object)resultJson);
            }
            log.info("{} {}:{} <--- {}ms", new Object[]{base.getPrivateDomain(), context.getMethod(), context.getPath(), cost});
        }
        catch (Exception e) {
            log.error("invoke method failed, path:{}, params:{}", new Object[]{context.getPath(), paramMap, e});
            return BjyResult.error((int)30000, (String)"\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        try {
            JavaType javaType = BjyServiceUtil.constructType(method.getGenericReturnType());
            return BjyServiceUtil.str2Obj(resultJson, javaType);
        }
        catch (Exception e) {
            log.error("parse resultJson failed, result:{}", (Object)resultJson, (Object)e);
            return BjyResult.error((int)30000, (String)"\u83b7\u53d6\u63a5\u53e3\u6570\u636e\u5931\u8d25");
        }
    }
}

