/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.base.BjyPartnerInfo;
import com.baijiayun.openapi.sdk.base.HeaderParam;
import com.baijiayun.openapi.sdk.base.PathParam;
import com.baijiayun.openapi.sdk.base.Request;
import com.baijiayun.openapi.sdk.base.RequestParam;
import com.baijiayun.openapi.sdk.utils.BjyServiceUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjyCallContext {
    private static final Logger log = LoggerFactory.getLogger(BjyCallContext.class);
    private BjyPartnerInfo baseReqDto;
    private String path;
    private Request.Method method;
    private Map<String, Object> params;
    private Map<String, Object> headers;
    private Type returnType;

    public static BjyCallContext from(Method method, Object[] args) {
        Request request = method.getAnnotation(Request.class);
        if (request == null) {
            throw new RuntimeException("method must be annotated with @Request");
        }
        return BjyCallContext.builder().baseReqDto(BjyCallContext.baseReqDto(args)).method(request.method()).path(BjyCallContext.pathOf(request, method, args)).params(BjyCallContext.requestParamsOf(method, args)).headers(BjyCallContext.headerParamsOf(method, args)).returnType(method.getGenericReturnType()).build();
    }

    private static BjyPartnerInfo baseReqDto(Object[] args) {
        for (Object arg : args) {
            if (!(arg instanceof BjyPartnerInfo)) continue;
            return (BjyPartnerInfo)arg;
        }
        throw new RuntimeException("no BjyPartnerInfo found in args");
    }

    private static String pathOf(Request request, Method method, Object[] args) {
        Map<String, String> pathParams = BjyCallContext.pathParamsOf(method, args);
        String path = request.path();
        for (Map.Entry<String, String> it : pathParams.entrySet()) {
            String name = it.getKey();
            String value = it.getValue();
            path = path.replace("{" + name + "}", value);
        }
        return path;
    }

    private static Map<String, String> pathParamsOf(Method method, Object[] args) {
        HashMap<String, String> params = new HashMap<String, String>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter it = parameters[i];
            PathParam param = it.getAnnotation(PathParam.class);
            if (param == null) continue;
            params.put(param.value(), String.valueOf(args[i]));
        }
        return params;
    }

    private static Map<String, Object> requestParamsOf(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter it = parameters[i];
            RequestParam requestParam = it.getAnnotation(RequestParam.class);
            Object arg = args[i];
            if (args[i] instanceof BjyPartnerInfo) continue;
            if (requestParam != null && requestParam.value() != null) {
                params.put(requestParam.value(), arg);
                continue;
            }
            if (arg == null) continue;
            if (arg instanceof Number || arg instanceof Boolean || arg instanceof CharSequence || arg instanceof File || arg instanceof Date || arg instanceof Enum || arg instanceof Collection || arg.getClass().isArray()) {
                params.put(it.getName(), arg);
                continue;
            }
            try {
                Map<String, String> map = BjyServiceUtil.beanToMap(args[i]);
                Map<String, File> files = BjyServiceUtil.beanToFileMap(args[i]);
                if (!map.isEmpty()) {
                    params.putAll(map);
                }
                if (files.isEmpty()) continue;
                params.putAll(files);
                continue;
            }
            catch (IOException e) {
                log.error("bean to map error", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return params;
    }

    private static Map<String, Object> headerParamsOf(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter it = parameters[i];
            HeaderParam headerParam = it.getAnnotation(HeaderParam.class);
            if (headerParam == null || headerParam.value() == null) continue;
            params.put(headerParam.value(), args[i]);
        }
        return params;
    }

    BjyCallContext(BjyPartnerInfo baseReqDto, String path, Request.Method method, Map<String, Object> params, Map<String, Object> headers, Type returnType) {
        this.baseReqDto = baseReqDto;
        this.path = path;
        this.method = method;
        this.params = params;
        this.headers = headers;
        this.returnType = returnType;
    }

    public static BjyCallContextBuilder builder() {
        return new BjyCallContextBuilder();
    }

    public BjyPartnerInfo getBaseReqDto() {
        return this.baseReqDto;
    }

    public String getPath() {
        return this.path;
    }

    public Request.Method getMethod() {
        return this.method;
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public void setBaseReqDto(BjyPartnerInfo baseReqDto) {
        this.baseReqDto = baseReqDto;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(Request.Method method) {
        this.method = method;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BjyCallContext)) {
            return false;
        }
        BjyCallContext other = (BjyCallContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BjyPartnerInfo this$baseReqDto = this.getBaseReqDto();
        BjyPartnerInfo other$baseReqDto = other.getBaseReqDto();
        if (this$baseReqDto == null ? other$baseReqDto != null : !this$baseReqDto.equals(other$baseReqDto)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Request.Method this$method = this.getMethod();
        Request.Method other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, Object> this$params = this.getParams();
        Map<String, Object> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        Map<String, Object> this$headers = this.getHeaders();
        Map<String, Object> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        Type this$returnType = this.getReturnType();
        Type other$returnType = other.getReturnType();
        return !(this$returnType == null ? other$returnType != null : !this$returnType.equals(other$returnType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BjyCallContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BjyPartnerInfo $baseReqDto = this.getBaseReqDto();
        result = result * 59 + ($baseReqDto == null ? 43 : $baseReqDto.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Request.Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, Object> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        Map<String, Object> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        Type $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 43 : $returnType.hashCode());
        return result;
    }

    public String toString() {
        return "BjyCallContext(baseReqDto=" + this.getBaseReqDto() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", params=" + this.getParams() + ", headers=" + this.getHeaders() + ", returnType=" + this.getReturnType() + ")";
    }

    public static class BjyCallContextBuilder {
        private BjyPartnerInfo baseReqDto;
        private String path;
        private Request.Method method;
        private Map<String, Object> params;
        private Map<String, Object> headers;
        private Type returnType;

        BjyCallContextBuilder() {
        }

        public BjyCallContextBuilder baseReqDto(BjyPartnerInfo baseReqDto) {
            this.baseReqDto = baseReqDto;
            return this;
        }

        public BjyCallContextBuilder path(String path) {
            this.path = path;
            return this;
        }

        public BjyCallContextBuilder method(Request.Method method) {
            this.method = method;
            return this;
        }

        public BjyCallContextBuilder params(Map<String, Object> params) {
            this.params = params;
            return this;
        }

        public BjyCallContextBuilder headers(Map<String, Object> headers) {
            this.headers = headers;
            return this;
        }

        public BjyCallContextBuilder returnType(Type returnType) {
            this.returnType = returnType;
            return this;
        }

        public BjyCallContext build() {
            return new BjyCallContext(this.baseReqDto, this.path, this.method, this.params, this.headers, this.returnType);
        }

        public String toString() {
            return "BjyCallContext.BjyCallContextBuilder(baseReqDto=" + this.baseReqDto + ", path=" + this.path + ", method=" + this.method + ", params=" + this.params + ", headers=" + this.headers + ", returnType=" + this.returnType + ")";
        }
    }
}

