package com.baijiayun.openapi.sdk.utils;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;

import java.io.IOException;
import java.util.Date;

/**
 * 将 Unix 时间戳转换为 Date
 *
 * @author yanmaoyuan
 * @date 2024/6/27
 */
public class UnixTimestampDeserializer extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return new Date(p.getValueAsLong() * 1000L);
    }
}
