package com.baijiayun.openapi.sdk.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.File;
import java.io.IOException;

/**
 * 由于jackson 序列化时，File 对象会序列化为文件路径，而 File 对象在序列化时，会触发 File 的 toString 方法。
 * 提交给百家云的 Http 请求中，File 应当作为 multipart/form-data 的请求体，而非 form-url-encoded 的请求体。
 *
 * @author yanmaoyuan
 * @date 2024/6/28
 */
public class IgnoreFileSerializer extends JsonSerializer<File> {
    @Override
    public void serialize(File value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        // 不做任何事，即忽略 File 对象
        gen.writeNull();
    }
}
