package com.baijiayun.openapi.sdk.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

/**
 * double 精确到小数点后两位
 *
 * @author yanmaoyuan
 * @date 2024/6/29
 */
public class DoublePrecisionSerializer extends JsonSerializer<Number> {

    private final DecimalFormat formatter;

    public DoublePrecisionSerializer() {
        formatter = new DecimalFormat("0.00");
        formatter.setRoundingMode(RoundingMode.HALF_UP);
    }

    @Override
    public void serialize(Number value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
        String format = formatter.format(bigDecimal);
        double dbl = Double.parseDouble(format);
        gen.writeNumber(dbl);
    }
}
