package com.baijiayun.openapi.sdk.event;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc: 直播间信令事件
 *
 * @author yanmaoyuan
 * @date 2024/1/9
 */
@Data
public class BjySignalEvent implements Serializable {
    private Long ts;// 事件发生的时间戳，单位：微秒
    @JsonProperty("room_id")
    private String roomId;//
    private String behavior;// 事件类型 进入教室:in 离开教室:out 摄像头开启:camera_on 摄像头关闭:camera_off 上课:live_start 下课:live_end 禁言:message_send_forbid 全体禁言:message_send_forbid_all
    private Integer duration;// 禁言时间，-1 表示无禁言时间 单位：秒
    private BjySignalEventTo to;// 被禁言的用户编号
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8", shape = JsonFormat.Shape.STRING)
    private Date time;
    @JsonProperty("time_usec")
    private Integer timeUsec;// 事件发生的微秒

    @JsonProperty("user_number")
    private String userNumber;// 用户编号
    @JsonProperty("user_role")
    private Integer userRole;// 用户角色 0:学生 1:老师 2:助教
    @JsonProperty("user_name")
    private String userName;// 用户名称
    @JsonProperty("user_avatar")
    private String userAvatar;// 用户头像
    @JsonProperty("user_ip")
    private String userIp;// IP 地址
    /**
     * @see com.baijiayun.openapi.sdk.enums.BjyClientType
     */
    @JsonProperty("client_type")
    private Integer clientType;// 0:PC网页 1:pc客户端 2:m站 3:ios 4:android 5:mac客户端 6:微信小程序
    private String area;// 省份
    private String city;// 城市
    @JsonProperty("custom_str")
    private String customStr;// 自定义字段

    @JsonProperty("create_time")
    private Long createTime;// 此参数用于计算网络时延，并不是由百家云消息队列发送的时间戳

    @JsonProperty("ref_product_id")
    private String refProductId;// 讲解商品
}
