package com.baijiayun.openapi.sdk.event;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class BjyCouponEventData implements Serializable {
    @JsonProperty("coupon_batch_no")
    private String couponBatchNo;

    @JsonProperty("coupon_sn")
    private String couponSn;

    @JsonProperty("draw_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8", shape = JsonFormat.Shape.STRING)
    private Date drawTime;

    @JsonProperty("user_number")
    private String userNumber;

    @JsonProperty("user_name")
    private String userName;

    @JsonProperty("room_id")
    private String roomId;

    @JsonProperty("custom_str")
    private String customStr;// 自定义字段
}
