package com.baijiayun.openapi.sdk.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BjyVideoTypeEnum {

    VIDEO(1, "点播"),
    PLAYBACK(2, "回放");

    private final Integer type;

    private final String desc;

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    BjyVideoTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, BjyVideoTypeEnum> TYPEMAP;

    static {
        TYPEMAP = Arrays.stream(BjyVideoTypeEnum.values()).collect(Collectors.toMap(BjyVideoTypeEnum::getType, Function.identity()));
    }

    public static BjyVideoTypeEnum getByType(Integer type) {
        return TYPEMAP.get(type);
    }
}
