package com.baijiayun.openapi.sdk.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BjyUpDownOpEnum {

    START(1, "start", "上课"),
    END(2, "end", "下课"),
    FORBID(3, "forbidden", "禁用直播间"),
    TEACHER_IN(4, "teacher_in", "老师进入教室"),
    TEACHER_OUT(5, "teacher_out", "老师退出教室"),
    UPDATE_DURATION(6, "stat", "上课时长更新"),

    PRODUCT_SHELF_CHANGE(7, "product_shelf_change", "商品讲解"),
    ;

    private Integer type;

    private String name;

    private String desc;

    public Integer getType() {
        return type;
    }

    public String getName() {
        return name;
    }

    public String getDesc() {
        return desc;
    }

    BjyUpDownOpEnum(Integer type, String name, String desc) {
        this.type = type;
        this.name = name;
        this.desc = desc;
    }

    private static final Map<String, BjyUpDownOpEnum> MAP;

    static {
        MAP = Arrays.stream(BjyUpDownOpEnum.values()).collect(Collectors.toMap(a -> a.getName(), Function.identity()));
    }
    public static BjyUpDownOpEnum getByName(String name) {
        return MAP.get(name);
    }


    private static final Map<Integer, BjyUpDownOpEnum> TYPEMAP;

    static {
        TYPEMAP = Arrays.stream(BjyUpDownOpEnum.values()).collect(Collectors.toMap(a -> a.getType(), Function.identity()));
    }
    public static BjyUpDownOpEnum getByType(Integer type) {
        return TYPEMAP.get(type);
    }
}
