package com.baijiayun.openapi.sdk.enums;

import lombok.Getter;

/**
 * desc: 百家云直播优惠券类型 0:满减券 1:直减券 2:折扣券 3:核销券
 *
 * @author yanmaoyuan
 * @date 2024/3/18
 */
@Getter
public enum BjyCouponType {
    FULL_REDUCTION(0, "满减券"),
    DIRECT_REDUCTION(1, "直减券"),
    DISCOUNT(2, "折扣券"),
    WRITE_OFF(3, "核销券");

    private final int value;
    private final String desc;

    BjyCouponType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }
}