package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetVideoPlayRecordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_id 点播视频ID
     */
    @JsonProperty("video_id")
    private String videoId;

    /**
     * [必填] start_time 查询起始时间，格式如：2017-09-0800:30:00。
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * [必填] end_time 查询结束时间，格式如：2017-09-0823:59:59。查询时间不能跨天
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 页码，从1开始，默认值是1
     */
    private Integer page;

    /**
     * 每页获取的记录条数，默认100，最大值不能超过1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}