package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetUsedFlowReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_id 视频ID
     */
    @JsonProperty("video_id")
    private String videoId;

    /**
     * [必填] start_date 查询起始日期，时间格式为yyyy-mm-dd，如：2017-08-01
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * [必填] end_date 查询结束日期，时间格式为yyyy-mm-dd，如：2017-08-01
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
}