package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetUsedFlowDetailReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] product_type 产品线类型，默认云点播（1:大班课 2:小班课 3:双师课堂 4:企业直播 5:云点播）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] date 查询那一天的日期 （时间格式为yyyy-mm-dd，如：2017-08-01 ）
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * 页码 默认值1
     */
    private Integer page;

    /**
     * 每页的条数 默认值100
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}