package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetPlaybackPlayRecordDto implements Serializable {

    /**
     * 一次播放的唯一标志，32 位字符串；如果跨天观看，数据按天拆分
     */
    @JsonProperty("guid")
    private String guid;

    @JsonProperty("date")
    private String date;

    /**
     * 回放对应的视频 id
     */
    @JsonProperty("video_id")
    private Integer videoId;

    /**
     * 用户名（需要客户在接入播放器的时候传入用户的信息）
     */
    @JsonProperty("user_name")
    private String userName;

    /**
     * 用户 number 号（需要客户在接入播放器的时候传入用户的信息）
     */
    @JsonProperty("user_number")
    private String userNumber;

    /**
     * 起始播放时间，格式如：2017-09-08 10:00:07
     */
    @JsonProperty("play_begin_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date playBeginTime;

    /**
     * 结束播放时间，格式如：2017-09-08 10:00:07
     */
    @JsonProperty("play_end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date playEndTime;

    /**
     * 实际观看时间，单位：秒
     */
    @JsonProperty("play_length")
    private Integer playLength;

    /**
     * 客户端类型 1：iphone 2:ipad 3：Android 4：手机 M 站 5：PC 网页
     * 6：APP 内嵌 M 站 7：小程序 8：Android 小程序 9：iOS 小程序 0:未知
     */
    @JsonProperty("client_type")
    private Integer clientType;

    /**
     * 用户 IP
     */
    @JsonProperty("user_ip")
    private String userIp;

    /**
     * 用户所在地域，格式如：省份 市。可能会为空
     */
    private String area;

    /**
     * 自定义上报字段
     */
    @JsonProperty("ext_data")
    private String extData;
}
