package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetVideoListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    private String name;

    /**
     * @see com.baijiayun.openapi.sdk.enums.BjyVideoStatus
     */
    private Integer status;

    /**
     * 页码，从1开始，默认值是1
     */
    private Integer page;

    /**
     * 每页条数，默认20，不得超过1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * create_time 过滤创建时间
     */
    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;
}