package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetUploadUrlReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] file_name 文件名
     */
    @JsonProperty("file_name")
    private String fileName;

    /**
     * [必填] definition 目标清晰度(16:标清 1:高清 2:超清 4:720p 8:1080p多种清晰度用英文逗号分隔)
     */
    private String definition;

    /**
     * 是否作为音频处理 0：否 1：是 默认0
     */
    @JsonProperty("audio_with_view")
    private Integer audioWithView;

    /**
     * 转码格式（1:mp4 2:flv 4:m3u8 多种格式用英文逗号分隔）默认是3种格式都转
     */
    private String format;

    /**
     * 水印图片地址，仅支持http/https开头的图片url
     */
    private String watermark;

    /**
     * 水印位置 1左上角 2右上角 3右下角 4左下角
     */
    @JsonProperty("watermark_pos")
    private Integer watermarkPos;

    /**
     * 是否生成加密格式视频1:是2:否（该功能需要申请加密视频的权限，开通加密视频权限后，默认都会加密）
     */
    private Integer encrypt;

    /**
     * 是否使用https上传地址，默认不使用
     */
    @JsonProperty("use_https")
    private Integer useHttps;

    /**
     * 为单个视频设置转码回调的地址，能够接收post请求
     */
    @JsonProperty("callback_url")
    private String callbackUrl;
}