package com.baijiayun.openapi.sdk.dto.smallcourse;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetUserCostReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] product_type 产品线类型（老账号 0  新账号 2）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] date 日期（Y-m-d）
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * [必填] room_id 直播间 id
     */
    @JsonProperty("room_id")
    private String roomId;
}